ORCA/M Asm65816 2.1.0

0001 9382              ****************************************************************
0002 9382              ****************************************************************
0003 9382              *
0004 9382              *
0005 9382              *                        Scrap Manager
0006 9382              *                        RAM Based Tool
0007 9382              *                         Version 2.0
0008 9382              *
0009 9382              *
0010 9382              *
0011 9382              * August 29, 1986   Steven E. Glass
0012 9382              *
0013 9382              * October 27, 1986  Steven E. Glass
0014 9382              *
0015 9382              *     Calls GetScrapCount and GetScrapState were missing.
0016 9382              *
0017 9382              * April 10, 1987    Steven E. Glass
0018 9382              *
0019 9382              *     BootInit and reset were incrementing busy flag.
0020 9382              *
0021 9382              * April 16, 1987    Steven E. Glass, Dan D. Hitchens
0022 9382              *
0023 9382              *     DisposeAllScraps wasn't disposing last handle.
0024 9382              *     PutScrap wasn't always reporting an error when out
0025 9382              *     of memory.
0026 9382              *
0027 9382              * March 02, 1988         v1.3d1     Harry Yee
0028 9382              *     The scrap manager has been converted over to the
0029 9382              *     MPW MAX development system.
0030 9382              *     The scrap manager has also been made rommable.
0031 9382              *
0032 9382              * March 22, 1988         v1.3d1     Steven Glass
0033 9382              *
0034 9382              *     Only the calltable is exported.   (no code changes)
0035 9382              *
0036 9382              *
0037 9382              * March 23, 1988         v1.3d2     Steven Glass
0038 9382              *
0039 9382              * The routine InitScrapInfo assumed that the OS was
0040 9382              * available for use.  When this code runs in ROM,
0041 9382              * InitScrapInfo is called from ScrapBootInit long before
0042 9382              * the OS is loaded.  I changed InitScrapInfo to check to
0043 9382              * see if the OS was available before making an OS call.
0044 9382              * The OS call being made is GetFileInfo which is checking
0045 9382              * to see if the clipboard file is present (i.e. whether
0046 9382              * the scrap is on disk or in memory. If the OS is not
0047 9382              * present then the code to check if the scrap is on disk
0048 9382              * is skipped and it is assumed that the scrap is in
0049 9382              * memory.
0050 9382              *
0051 9382              * Other routines will have to be checked to see what
0052 9382              * should happen under similar circumstances.
0053 9382              *
0054 9382              * April 29, 1988         v1.3d3     Harry Yee
0055 9382              *
0056 9382              * ScrapReset would always fail because the a-reg was not
0057 9382              * zero upon exit from ScrapReset, even though no error
0058 9382              * had ocurred.  A-reg is cleared just before exit now.
0059 9382              *
0060 9382              * May 6, 1988            v1.3d4     Harry Yee
0061 9382              *
0062 9382              * In the call GetScrapSize if there was an invalid scrap
0063 9382              * opened from LoadTheScrap (i.e. an error occurred trying
0064 9382              * to read it) the clipboard file was left opened, which
0065 9382              * caused problems for some ProDOS calls which lock down
0066 9382              * the disk if files are left open and then you move this
0067 9382              * disk to another driver before making the ProDOS call.
0068 9382              * I now close make sure the clipboard file is closed.
0069 9382              *
0070 9382              * June 2, 1988           v1.3d5     Harry Yee
0071 9382              *
0072 9382              * Set the no special memory attribute bit for the memory
0073 9382              * I allocated at bootinit.
0074 9382              *
0075 9382              * June 30, 1988          v1.4d1     Harry Yee
0076 9382              *
0077 9382              * Version 1.4 to be included on System Disk 4.0:
0078 9382              * In ScrapBootInit WAP was being set to the ptr of locked
0079 9382              * down handle (MemPtr) instead of to the unlocked handle
0080 9382              * itself (MemHandle).
0081 9382              * Now the memory that is obtained during Bootinit is
0082 9382              * locked when its used and unlocked otherwise.
0083 9382              * Also ScrapReset has been completely rewritten to just
0084 9382              * dispose of all memory allocated by the Scrap Manager
0085 9382              * and then its WAP is set to zero. ScrapReset used to
0086 9382              * dispose of the previous scrap (i.e. clipboard file)
0087 9382              * which it no longer does.
0088 9382              * InitScrapInfo has been done away with and incorporated
0089 9382              * into ScrapBootInit.
0090 9382              *
0091 9382              * August 9, 1988     v1.4d2 (for System Disk 4.0d16) HY
0092 9382              *
0093 9382              * ScrapBootInit was not checking if WAP was non-zero
0094 9382              * before allocating memory for itself. Problem occurrs if
0095 9382              * ones does a LoadOneTool and Scrap Mgr already loaded.
0096 9382              * Two additional handles are created each time
0097 9382              * ScrapBootInit is called. Bug can be verified by just
0098 9382              * going into BASIC and then quitting.   We now check WAP
0099 9382              * if non-zero we re-initialize the scrap path and then
0100 9382              * get the hell out of there.
0101 9382              *
0102 9382              *
0103 9382              * 12 Aug 88         Steven Glass
0104 9382              *
0105 9382              * The UnloadScrap called WriteOutScrap which was pushing 
0106 9382              * the wrong pointer to the file ref num and leaving 
0107 9382              * the file open.
0108 9382              *
0109 9382              * Subsequent calls to read the scrap would fail because
0110 9382              * of file aready open.
0111 9382              *
0112 9382              * 19 Apr 89         Yee
0113 9382              *
0114 9382              * Changed version number from 1.4 to 3.0.
0115 9382              *
0116 9382              ****************************************************************
0117 9382              DebugSymbols equ   0
0118 9382
0119 9382                       include 'All.Macros' 
0120 9382                       include 'Special.Macros' 
0121 9382                       include 'E16.Window' 
0122 9382                       include 'E16.Locator' 
0123 9382
0124 9382              ****************************************************************
0125 9382              *                                                              *
0126 9382              *           Copyright Apple Computer, Inc. 1985-92             *
0127 9382              *                   All Rights Reserved                        *
0128 9382              *                                                              *
0129 9382              ****************************************************************
0130 9382
0131 9382
0132 9382              ;------------------------------------------
0133 9382              ;
0134 9382              ;   Global Equates
0135 9382              ;
0136 9382              ;------------------------------------------
0137 9382              DebugVersion equ   0
0138 9382
0139 9382              TRUE     equ   $FFFF
0140 9382              FALSE    equ   $0
0141 9382
0142 9382              ScrapUserID equ   $4201                 ; special ID used so scrap memory will
0143 9382                                                      ; not get its purge level set to 3 by loader
0144 9382              ToolNum  equ   22
0145 9382
0146 9382              ;----------------------------------------------------
0147 9382              ;
0148 9382              ; Zero page equates.
0149 9382              ;
0150 9382              ScrapTablePtr equ   1                   ; offset 1 because the old data bank is stored at 0 
0151 9382              OffsetToThisOne equ   ScrapTablePtr+4
0152 9382              PtrToThisOne equ   OffsetToThisOne+4
0153 9382              DestHandle equ   PtrToThisOne+4
0154 9382              DestPtr  equ   DestHandle+4
0155 9382              WAPEntry equ   DestPtr+4
0156 9382              MemHandle equ   WAPEntry+4
0157 9382              MemPtr   equ   MemHandle+4
0158 9382              OrigDirect equ   MemPtr+4
0159 9382              StdZPSize equ   OrigDirect-1
0160 9382
0161 9382              ******************************************************************************
0162 9382              *
0163 9382              * Scrap Type constants
0164 9382              *
0165 9382              * References:
0166 9382              *   Apple IIgs Toolbox Reference Volume 1
0167 9382              *   Apple IIgs Technical Note #99, Supplemental Scrap Types
0168 9382              *
0169 9382              ******************************************************************************
0170 9382              textScrap equ   $0000                   ;text
0171 9382              picScrap equ   $0001                    ;QuickDraw II picture
0172 9382              soundScrap equ   $0002                  ;sound in rSoundSample format
0173 9382              teStyleScrap equ   $0064                ;Text Edit style information for text
0174 9382              iconScrap equ   $4945                   ;icon with name/owner information
0175 9382              maskScrap equ   $8001                   ;QuickDraw II picture to be used as a mask
0176 9382              colorScrap equ   $8002                  ;GS color tables (32 bytes each)
0177 9382              ; need more HCGS scrap types??
0178 9382
0179 9382              ;----------------------------------------------------
0180 9382              ;
0181 9382              ; Scrap Record
0182 9382              ;
0183 9382              o_ScrapType equ   0
0184 9382              o_ScrapSize equ   2
0185 9382              o_ScrapHandle equ   6
0186 9382              ScrapRecSize equ   10
0187 9382
0188 9382
0189 9382              ;----------------------------------------------------
0190 9382              ;
0191 9382              ; ScrapAttributes for the memory I get
0192 9382              ScrapAttributes equ   $0008             ; not special memory
0193 9382
0194 9382
0195 9382              ;----------------------------------------------------
0196 9382              ;
0197 9382              ; File type for clipboard file.
0198 9382              ;
0199 9382              ClipFileType equ   $f9                  ;changed from 0 to $f9 19-Nov-90 DAL
0200 9382              *ClipAuxType	equ	0
0201 9382
0202 9382              ;-----------------------------------------------------------
0203 9382              ;
0204 9382              ; Error Codes we need to label.
0205 9382              ;
0206 9382              FileNotFound equ   $46                  ; ProDOS error
0207 9382
0208 9382              NotImpError equ   $16FF
0209 9382              TypeError equ   $1610
0210 9382
0211 9382              ;-----------------------------------------------------------
0212 9382              ;
0213 9382              ; Equates for OS entry points.
0214 9382              ;
0215 9382              OS_ENTRY equ   $E100A8
0216 9382              OS_ENTRY2 equ   $E100B0
0217 9382              OS_Zero  equ   $E100BA
0218 9382              OS_Kind  equ   $E100BC
0219 9382              OS_Boot  equ   $E100BD
0220 9382
0221 9382              ;-----------------------------------------------------------
0222 9382              ;
0223 9382              ; Memory Manager attributes
0224 9382              ;
0225 9382              Attr_Locked equ   $8000                 ; 1 = Locked
0226 9382              Attr_Fixed equ   $4000                  ; 1 = Not movable
0227 9382              Attr_Purge equ   $0300                  ; 0 = No purge 1-3 purge level
0228 9382              Attr_NoCross equ   $0010                ; 1 = May not cross banks
0229 9382              Attr_NoSpec equ   $0008                 ; 1 = May not use special memory
0230 9382              Attr_Page equ   $0004                   ; 1 = Page Aligned
0231 9382              Attr_Addr equ   $0002                   ; 1 = Fixed address
0232 9382              Attr_Bank equ   $0001                   ; 1 = Fixed address
0233 9382
0234 9382
0235 9382              ;-----------------------------------------------
0236 9382              ;
0237 9382              ;   Equates for Stack based ProDOS calls
0238 9382              ;   and other memory locations that needed space
0239 9382              ;   because code is being made non-self modifying
0240 9382              ;
0241 9382              CreateCall equ   $01
0242 9382              DestroyCall equ   $02
0243 9382              GetFileInfo equ   $06
0244 9382              OpenCall equ   $10
0245 9382              ReadCall equ   $12
0246 9382              WriteCall equ   $13
0247 9382              CloseCall equ   $14
0248 9382
0249 9382              StackProDOS equ   $E100B0
0250 9382
0251 9382              ;Open Call Parameters:
0252 9382              OpenParams equ   0
0253 9382              OpenID   equ   0                        ; reference number assigned to file by the OPEN call
0254 9382              OpenPath equ   OpenID+2                 ; pointer to pathname of file to open
0255 9382              OpenBuf  equ   OpenPath+4               ; pointer to I/O buffer
0256 9382
0257 9382              ;Read Call Parameters:
0258 9382              ReadParams equ   0
0259 9382              ReadID   equ   0                        ; reference number assigned to file by the OPEN call
0260 9382              ReadTo   equ   ReadID+2                 ; pointer to location of buffer where data is read into
0261 9382              ReadAmount equ   ReadTo+4               ; the number of bytes to be transferred
0262 9382
0263 9382              ;Write Call Parameters:
0264 9382              WriteParams equ   0
0265 9382              WriteID  equ   0                        ; reference number assigned to file by the OPEN call
0266 9382              WriteFrom equ   WriteID+2               ; pointer to location of where data is to be written to
0267 9382              WriteAmount equ   WriteFrom+4           ; number of bytes to write
0268 9382
0269 9382              ;Close Call Parameters:
0270 9382              CloseParams equ   0
0271 9382              CloseRef equ   0                        ; reference number assigned to file by the OPEN call
0272 9382
0273 9382              ;Create Call Parameters:
0274 9382              CreateParams equ   ReadAmount+8
0275 9382              CreatePath equ   ReadAmount+8           ; pointer to pathname of file to create
0276 9382              CreateAccess equ   CreatePath+4         ; word value, how file may be accessed
0277 9382              CreateFileType equ   CreateAccess+2     ; file type of file
0278 9382              CreateAuxType equ   CreateFileType+2    ; file's auxiliary type
0279 9382              CreateStType equ   CreateAuxType+4      ; logical organization of file
0280 9382              CreateDate equ   CreateStType+2         ; date which file was created
0281 9382              CreateTime equ   CreateDate+2           ; time at which file was created
0282 9382
0283 9382              ;Destroy Call Parameters:
0284 9382              DestroyParams equ   CreateTime+2
0285 9382              DestroyPath equ   CreateTime+2
0286 9382
0287 9382              HowMuchToWrite equ   DestroyParams+4
0288 9382              HowMuchToRead equ   HowMuchToWrite+4
0289 9382              NumEntries equ   HowMuchToRead+4        ; used when reading the clipboard file from disk
0290 9382              FirstScrapHandle equ   NumEntries+2
0291 9382              ScrapState equ   FirstScrapHandle+4     ; ScrapState indicates whether scrap is currently in memory or on disk
0292 9382              ScrapCount equ   ScrapState+2           ; ScrapCount is incremented each time zero scrap is called
0293 9382              ScrapHandle equ   ScrapCount+2
0294 9382              ScrapName equ   ScrapHandle+4           ; Pointer to pathname of clipboard file.
0295 9382              FIParams equ   ScrapName+4
0296 9382              TotalMem equ   FIParams+29
0297 9382
0298 9382
0299 9382              ;-----------------------------------------------
0300 9382              ; 
0301 9382              ;  System Equates
0302 9382              ;
0303 9382              IncBusyFlg equ   $E10064
0304 9382              DecBusyFlg equ   $E10068
0305 9382
0306 9382              ;-----------------------------------------------
0307 9382              ;
0308 9382              ;           Imported address
0309 9382              ;
0310 9382              ;-----------------------------------------------
0311 9382
0312 9382                       IMPORT OERROUT 
0313 9382                       IMPORT OENDCALL 
0314 9382                       IMPORT BUSYERR 
0315 9382
0316 9382              ;-----------------------------------------------
0317 9382              ;
0318 9382              ;           Forward address and entries
0319 9382              ;
0320 9382              ;-----------------------------------------------
0321 9382
0322 9382                       ENTRY ExitNoError
0323 9382                       ENTRY ScrapPath
0324 9382                       ENTRY GetScrapState
0325 9382                       ENTRY GetScrapCount
0326 9382                       ENTRY SetScrapPath
0327 9382                       ENTRY GetScrapPath
0328 9382                       ENTRY GetScrapSize
0329 9382                       ENTRY GetScrapHandle
0330 9382                       ENTRY GetScrap
0331 9382                       ENTRY PutScrap
0332 9382                       ENTRY ZeroScrap
0333 9382                       ENTRY LoadScrap
0334 9382                       ENTRY UnloadScrap
0335 9382                       ENTRY NotImp
0336 9382                       ENTRY ScrapStatus
0337 9382                       ENTRY ScrapReset
0338 9382                       ENTRY ScrapVersion
0339 9382                       ENTRY ScrapBootInit
0340 9382                       ENTRY StartScrapCall
0341 9382                       ENTRY EndScrapCall
0342 9382                       ENTRY DisposeAllScraps
0343 9382                       ENTRY DerefFirstHandle
0344 9382                       ENTRY UnlockFirstHandle
0345 9382                       ENTRY WriteOutThisOne
0346 9382                       ENTRY WriteOutScrap
0347 9382                       ENTRY EndScrapCall
0348 9382                       ENTRY LoadTheScrap
0349 9382                       ENTRY DeleteClipboard
0350 9382                       ENTRY FindThisType
0351 9382                       ENTRY DerefDest
0352 9382                       ENTRY ReadInThisOne
0353 9382                       ENTRY UnlockDest
0354 9382
0355 9382              ****************************************************************
0356 9382              *
0357 9382              * ScrapCallTable
0358 9382              *
0359 9382              ****************************************************************
0360 9382                       EXPORT ScrapCallTable 
0361 9382              ScrapCallTable PROC 
0362 9382              TheBeginning  
0363 9382 14 00 00 00           DC L:(TheEnd-TheBeginning)/4   ; call count + 1
0364 9386 D1 93 FC 00           DC L:ScrapBootInit-1           ; 0116
0365 938A 29 95 FC 00           DC L:ScrapStartUp-1            ; 0216
0366 938E 30 95 FC 00           DC L:ScrapShutDown-1           ; 0316
0367 9392 37 95 FC 00           DC L:ScrapVersion-1            ; 0416 version call
0368 9396 41 95 FC 00           DC L:ScrapReset-1              ; 0516 reset call
0369 939A 61 95 FC 00           DC L:ScrapStatus-1             ; 0616 status call
0370 939E 6D 95 FC 00           DC L:NotImp-1                  ; 0716
0371 93A2 6D 95 FC 00           DC L:NotImp-1                  ; 0816
0372 93A6 8A 95 FC 00           DC L:UnloadScrap-1             ; 0916
0373 93AA A4 95 FC 00           DC L:LoadScrap-1               ; 0A16
0374 93AE CF 95 FC 00           DC L:ZeroScrap-1               ; 0B16
0375 93B2 05 96 FC 00           DC L:PutScrap-1                ; 0C16
0376 93B6 52 97 FC 00           DC L:GetScrap-1                ; 0D16
0377 93BA CD 97 FC 00           DC L:GetScrapHandle-1          ; 0E16
0378 93BE 1A 98 FC 00           DC L:GetScrapSize-1            ; 0F16
0379 93C2 67 98 FC 00           DC L:GetScrapPath-1            ; 1016
0380 93C6 90 98 FC 00           DC L:SetScrapPath-1            ; 1116
0381 93CA B9 98 FC 00           DC L:GetScrapCount-1           ; 1216
0382 93CE DC 98 FC 00           DC L:GetScrapState-1           ; 1316
0383 93D2              TheEnd    
0384 93D2                       ENDP 
0385 93D2
0386 93D2
0387 93D2              ****************************************************************
0388 93D2              *
0389 93D2              * ScrapBootInit     (No inputs)
0390 93D2              *
0391 93D2              * Modification History
0392 93D2              *
0393 93D2              * 10 Apr 87    SEG
0394 93D2              *
0395 93D2              *    Was not decrementing busy flag on way out.
0396 93D2              *
0397 93D2              * 30 Jun 88    Harry Yee
0398 93D2              *                   InitScrapInfo has been incorporated into this 
0399 93D2              *                   routine.
0400 93D2              *
0401 93D2              ****************************************************************
0402 93D2                       ENTRY ScrapBootInit
0403 93D2              ScrapBootInit PROC 
0404 93D2
0405 93D2              TheMemPtr equ   1
0406 93D2              TheFirstScrapPtr equ   TheMemPtr+4
0407 93D2              TheFirstScrapHandle equ   TheFirstScrapPtr+4
0408 93D2              TheMemHandle equ   TheFirstScrapHandle+4
0409 93D2              OrigB    equ   TheMemHandle+4
0410 93D2              OrigD    equ   OrigB+1
0411 93D2
0412 93D2
0413 93D2 22 64 00 E1           jsl   IncBusyFlg
0414 93D6
0415 93D6 0B                    phd                            ; save direct page register
0416 93D7 8B                    phb   
0417 93D8 4B                    phk                            ; set data bank register
0418 93D9 AB                    plb   
0419 93DA
0420 93DA C0 00 00              cpy   #0
0421 93DD F0 27                 beq   NotInited
0422 93DF 5A                    phy                            ; push MemHandle on stack
0423 93E0 48                    pha   
0424 93E1 48                    pha                            ; space for FirstScrapHandle
0425 93E2 48                    pha   
0426 93E3 48                    pha                            ; space for FirstScrapPtr
0427 93E4 48                    pha   
0428 93E5 48                    pha                            ; space for MemPtr
0429 93E6 48                    pha   
0430 93E7 3B                    tsc   
0431 93E8 5B                    tcd                            ; turn stack into our zero page
0432 93E9
0433 93E9 A7 0D                 lda   [TheMemHandle]           ; deref TheMemHandle
0434 93EB 85 01                 sta   TheMemPtr
0435 93ED A0 02 00              ldy   #2
0436 93F0 B7 0D                 lda   [TheMemHandle],y
0437 93F2 85 03                 sta   TheMemPtr+2
0438 93F4
0439 93F4 A9 78 95              lda   #ScrapPath               ; reset the name to be used
0440 93F7 A0 3A 00              ldy   #ScrapName               ; in case it was changed.
0441 93FA 97 01                 sta   [TheMemPtr],y
0442 93FC A9 FC 00              lda   #^ScrapPath
0443 93FF C8                    iny   
0444 9400 C8                    iny   
0445 9401 97 01                 sta   [TheMemPtr],y
0446 9403
0447 9403 82 F0 00              brl   GoHome
0448 9406
0449 9406 F4 00 00 F4  NotInited PushLong #0                   ; memory to be used for ProDOS calls and other junk
0450 940C F4 00 00 F4           PushLong #TotalMem 
0451 9412 F4 01 42              PushWord #ScrapUserID 
0452 9415 F4 08 80              PushWord #Attr_Locked+Attr_NoSpec 
0453 9418 F4 00 00 F4           PushLong #0 
0454 941E A2 02 09 22           _NewHandle 
0455 9425 90 03                 bcc   NoError1
0456 9427 82 FB 00              brl   Error1
0457 942A
0458 942A F4 00 00 F4  NoError1 PushLong #0 
0459 9430 F4 00 00 F4           PushLong #2 
0460 9436 F4 01 42              PushWord #ScrapUserID 
0461 9439 F4 08 00              PushWord #Attr_NoSpec 
0462 943C F4 00 00 F4           PushLong #0 
0463 9442 A2 02 09 22           _NewHandle 
0464 9449 90 03                 bcc   NoError2
0465 944B 82 D5 00              brl   Error2
0466 944E
0467 944E 48           NoError2 pha                            ; space for TheFirstScrapPtr
0468 944F 48                    pha   
0469 9450 48                    pha                            ; space for TheMemPtr
0470 9451 48                    pha   
0471 9452 3B                    tsc                            ; switch in stack to be out zero page
0472 9453 5B                    tcd   
0473 9454
0474 9454 A7 0D                 lda   [TheMemHandle]           ; deref TheMemHandle
0475 9456 85 01                 sta   TheMemPtr
0476 9458 A0 02 00              ldy   #2
0477 945B B7 0D                 lda   [TheMemHandle],y
0478 945D 85 03                 sta   TheMemPtr+2
0479 945F
0480 945F A7 09                 lda   [TheFirstScrapHandle]    ; deref FirstScrapHandle
0481 9461 85 05                 sta   TheFirstScrapPtr
0482 9463 B7 09                 lda   [TheFirstScrapHandle],y
0483 9465 85 07                 sta   TheFirstScrapPtr+2
0484 9467
0485 9467 A5 09                 lda   TheFirstScrapHandle      ; save TheFirstScrapHandle
0486 9469 A0 2E 00              ldy   #FirstScrapHandle
0487 946C 97 01                 sta   [TheMemPtr],y
0488 946E C8                    iny   
0489 946F C8                    iny   
0490 9470 A5 0B                 lda   TheFirstScrapHandle+2
0491 9472 97 01                 sta   [TheMemPtr],y
0492 9474
0493 9474 A9 78 95              lda   #ScrapPath               ; reset the name to be used
0494 9477 A0 3A 00              ldy   #ScrapName               ; in case it was changed.
0495 947A 97 01                 sta   [TheMemPtr],y
0496 947C A9 FC 00              lda   #^ScrapPath
0497 947F C8                    iny   
0498 9480 C8                    iny   
0499 9481 97 01                 sta   [TheMemPtr],y
0500 9483
0501 9483 A9 00 00              lda   #0
0502 9486 87 05                 sta   [TheFirstScrapPtr]
0503 9488
0504 9488              ;----------------------------------------------------
0505 9488              ;
0506 9488              ; Now we look for the scrap.  We start by assuming
0507 9488              ; that the scrap is on disk
0508 9488              ;
0509 9488 A9 00 00              lda   #0
0510 948B A0 32 00              ldy   #ScrapState
0511 948E 97 01                 sta   [TheMemPtr],y
0512 9490
0513 9490              ;----------------------------------------------------
0514 9490              ;
0515 9490              ; Look for clipboard file
0516 9490              ;
0517 9490
0518 9490              ; Now, if OS is active, we should look for the
0519 9490              ; clipboard file, otherwise assume the clipboard
0520 9490              ; is in memory.
0521 9490              ;
0522 9490 AF A8 00 E1           lda   >OS_ENTRY                ; for the os to be active, this must be
0523 9494 29 FF 00              and   #$00FF                   ; 5C, for JML op opcode.
0524 9497 C9 5C 00              cmp   #$005C
0525 949A D0 4A                 bne   NotActive
0526 949C
0527 949C AF B0 00 E1           lda   >OS_ENTRY2               ; for the os to be active, this must be
0528 94A0 29 FF 00              and   #$00FF                   ; 5C, for JML op opcode.
0529 94A3 C9 5C 00              cmp   #$005C
0530 94A6 D0 3E                 bne   NotActive
0531 94A8
0532 94A8 AF BA 00 E1           lda   >OS_Zero                 ; for os to be active, this must be zero
0533 94AC D0 38                 bne   NotActive
0534 94AE
0535 94AE AF BC 00 E1           lda   >OS_Kind                 ; for os to be active, this must be one
0536 94B2 29 01 00              and   #$0001
0537 94B5 F0 2F                 beq   NotActive
0538 94B7
0539 94B7 AF BD 00 E1           lda   >OS_Boot                 ; for os to be active, this must be one
0540 94BB 29 01 00              and   #$0001
0541 94BE F0 26                 beq   NotActive
0542 94C0
0543 94C0 A9 78 95              lda   #ScrapPath               ; setup the parameters in memory 
0544 94C3 A0 3E 00              ldy   #FIParams                ; for the ProDOS GetFileInfo call.
0545 94C6 97 01                 sta   [TheMemPtr],y
0546 94C8 A9 FC 00              lda   #^ScrapPath
0547 94CB C8                    iny   
0548 94CC C8                    iny   
0549 94CD 97 01                 sta   [TheMemPtr],y
0550 94CF
0551 94CF A5 01                 lda   TheMemPtr
0552 94D1 18                    clc   
0553 94D2 69 3E 00              adc   #FIParams
0554 94D5 AA                    tax   
0555 94D6 A5 03                 lda   TheMemPtr+2
0556 94D8 69 00 00              adc   #0
0557 94DB 48                    pha   
0558 94DC DA                    phx   
0559 94DD
0560 94DD F4 06 00              pea   GetFileInfo              ; check if the file */system/clipboard is there
0561 94E0 22 B0 00 E1           jsl   StackProDOS
0562 94E4
0563 94E4 90 08                 bcc   ScrapIsOnDisk
0564 94E6
0565 94E6 A9 01 00     NotActive lda   #1
0566 94E9 A0 32 00              ldy   #ScrapState
0567 94EC 97 01                 sta   [TheMemPtr],y
0568 94EE
0569 94EE
0570 94EE A9 00 00     ScrapIsOnDisk lda   #0
0571 94F1 A0 34 00              ldy   #ScrapCount
0572 94F4 97 01                 sta   [TheMemPtr],y
0573 94F6
0574 94F6 F4 00 00     GoHome   PushWord #0 
0575 94F9 F4 16 00              PushWord #ToolNum              ; tool022
0576 94FC A5 0F 48 A5           PushLong TheMemHandle 
0577 9502 A2 01 0D 22           _SetWAP 
0578 9509
0579 9509 A0 04 00              ldy   #4                       ; unlock TheMemHandle
0580 950C B7 0D                 lda   [TheMemHandle],y
0581 950E 29 FF 7F              and   #$7FFF
0582 9511 97 0D                 sta   [TheMemHandle],y
0583 9513
0584 9513 68                    pla                            ; get rid of TheMemPtr
0585 9514 68                    pla   
0586 9515 68                    pla                            ; get rid of TheFirstScrapPtr
0587 9516 68                    pla   
0588 9517 68                    pla                            ; get rid of TheFirstScrapHandle
0589 9518 68                    pla   
0590 9519 68                    pla                            ; get rid of TheMemHandle
0591 951A 68                    pla   
0592 951B AB           Out      plb                            ; restore original data bank 
0593 951C
0594 951C A0 00 00              ldy   #0
0595 951F 5C AA FC FE           jml   BusyErr                  ; OrigD left on stack for BusyErr to restore
0596 9523
0597 9523 FA           Error2   plx                            ; get rid of TheFirstScrapHandle
0598 9524 FA                    plx   
0599 9525
0600 9525 FA           Error1   plx                            ; get rid of TheMemHandle
0601 9526 FA                    plx   
0602 9527
0603 9527 AA                    tax                            ; put error in x-reg
0604 9528 80 F1                 bra   Out
0605 952A
0606 952A                       export ScrapStartUp 
0607 952A              ScrapStartUp  
0608 952A A0 00 00              ldy   #0
0609 952D 5C ED FC FE           jml   oEndCall
0610 9531
0611 9531                       export ScrapShutDown 
0612 9531              ScrapShutDown  
0613 9531 A0 00 00              ldy   #0
0614 9534 5C ED FC FE           jml   oEndCall
0615 9538
0616 9538                       ENDP 
0617 9538
0618 9538
0619 9538              ****************************************************************
0620 9538              *
0621 9538              * ScrapVersion
0622 9538              *
0623 9538              ****************************************************************
0624 9538                       ENTRY ScrapVersion
0625 9538              ScrapVersion PROC export 
0626 9538
0627 9538              ScrapVersionNumber equ   $0300
0628 9538
0629 9538 A9 00 03              lda   #ScrapVersionNumber
0630 953B
0631 953B                       export ReturnOneWord 
0632 953B 83 07        ReturnOneWord sta   7,s
0633 953D
0634 953D                       export ExitNoError 
0635 953D A9 00 00     ExitNoError lda   #0
0636 9540 18                    clc   
0637 9541 6B                    rtl   
0638 9542
0639 9542                       ENDP 
0640 9542
0641 9542
0642 9542              ****************************************************************
0643 9542              *
0644 9542              * ScrapReset
0645 9542              *
0646 9542              * Modification History
0647 9542              *
0648 9542              * 10 Apr 87    SEG
0649 9542              *
0650 9542              *    Was not decrementing busy flag on way out.
0651 9542              *
0652 9542              * 29 Apr 88    HY
0653 9542              *
0654 9542              *    A-Reg contained a non-zero value when it exited whether or not
0655 9542              *    an error occurred. Therefore ScrapReset would always fail.    
0656 9542              *
0657 9542              * 08 Jun 88    HY
0658 9542              *
0659 9542              *    ScrapReset now just disposes of all the memory allocated by
0660 9542              *    the Scrap Manager and sets the WAP to zero.
0661 9542              *
0662 9542              * 19 Sep 88    SEG
0663 9542              *
0664 9542              *    The setWAP call had the wrong inputs.
0665 9542              *    In addition, after a reset, the ScrapMgr has no memeory
0666 9542              *    so we need to call the boot init call again to make things
0667 9542              *    Kosher.
0668 9542              *
0669 9542              ****************************************************************
0670 9542                       ENTRY ScrapReset
0671 9542              ScrapReset PROC 
0672 9542
0673 9542 F4 01 42              PushWord #ScrapUserID 
0674 9545 A2 02 11 22           _DisposeAll                    ; get rid of all memory allocated
0675 954C                                                      ; to the scrap manager
0676 954C F4 00 00 F4           PushLong #ToolNum              ; system tool set
0677 9552 F4 00 00 F4           PushLong #0                    ; set the wap to zero
0678 9558 A2 01 0D 22           _SetWAP 
0679 955F
0680 955F 82 70 FE              brl   ScrapBootInit
0681 9562
0682 9562                       ENDP 
0683 9562
0684 9562
0685 9562              ****************************************************************
0686 9562              *
0687 9562              * ScrapStatus
0688 9562              *
0689 9562              * Returns true all the time since if we are loaded, we are
0690 9562              * active.
0691 9562              *
0692 9562              ****************************************************************
0693 9562                       ENTRY ScrapStatus
0694 9562              ScrapStatus PROC 
0695 9562                       import ReturnOneWord 
0696 9562
0697 9562 A9 FF FF              lda   #True
0698 9565 83 07                 sta   7,s
0699 9567 A0 00 00              ldy   #0
0700 956A 5C ED FC FE           jml   oEndCall
0701 956E
0702 956E
0703 956E                       ENDP 
0704 956E
0705 956E
0706 956E              ****************************************************************
0707 956E              *
0708 956E              * NotImp
0709 956E              *
0710 956E              * Error return for calls 7 and 8
0711 956E              *
0712 956E              ****************************************************************
0713 956E                       ENTRY NotImp
0714 956E              NotImp   PROC 
0715 956E
0716 956E A2 FF 16              ldx   #NotImpError
0717 9571 A0 00 00              ldy   #0
0718 9574 5C B4 FC FE           jml   oEndCall
0719 9578
0720 9578                       ENDP 
0721 9578
0722 9578
0723 9578              ****************************************************************
0724 9578              *
0725 9578              * ScrapDATA
0726 9578              *
0727 9578              * The data structures for the ScrapManager are as follows.
0728 9578              *
0729 9578              * Below we keep a handle called FirstScraphandle.  This is a
0730 9578              * reference to a scrap table.  In the scrap table are
0731 9578              * a series of scrap records.  There is one record for each scrap
0732 9578              * type represented in the table.
0733 9578              *
0734 9578              * Each ScrapRecord in the ScrapTable contains the following
0735 9578              * information:
0736 9578              *
0737 9578              *        ScrapType
0738 9578              *        ScrapSize
0739 9578              *        ScrapHandle
0740 9578              *
0741 9578              *
0742 9578              *
0743 9578              ****************************************************************
0744 9578                       ENTRY ScrapData
0745 9578              ScrapData PROC 
0746 9578
0747 9578              ;----------------------------------------------------
0748 9578              ;
0749 9578              ; Scrap data structure
0750 9578              ;
0751 9578              ; NumTypes in Scrap  integer
0752 9578              ;     ScrapType1
0753 9578              ;     SizeofScrap1
0754 9578              ;     HandleToScrap1
0755 9578              ;
0756 9578              ;     ScrapType2
0757 9578              ;     SizeOfScrap2
0758 9578              ;     HandleToScrap2
0759 9578              ;
0760 9578              ;     ...
0761 9578              ;
0762 9578              ;     ScrapTypeN
0763 9578              ;     SizeOfScrapN
0764 9578              ;     HandleToScrapN
0765 9578              ;
0766 9578
0767 9578
0768 9578              ;----------------------------------------------------
0769 9578              ;
0770 9578              ; The scrap path is the default clipboard path name
0771 9578              ; The file name is CLIPBOARD in the SYSTEM subdirectory
0772 9578              ; of the boot volume.
0773 9578              ;
0774 9578                       ENTRY ScrapPath
0775 9578 12 2A 2F 73  ScrapPath DC C:'*/System/Clipboard'
0776 958B
0777 958B
0778 958B                       ENDP 
0779 958B
0780 958B
0781 958B              ****************************************************************
0782 958B              *
0783 958B              * UnloadScrap
0784 958B              *
0785 958B              *      No parameters.
0786 958B              *
0787 958B              * Writes the scrap from memory to disk.
0788 958B              *
0789 958B              ****************************************************************
0790 958B                       ENTRY UnloadScrap
0791 958B              UnloadScrap PROC export 
0792 958B
0793 958B 5A                    phy   
0794 958C 48                    pha   
0795 958D
0796 958D 20 00 99              jsr   StartScrapCall
0797 9590
0798 9590 A0 32 00              ldy   #ScrapState
0799 9593 B7 1D                 lda   [<MemPtr],y
0800 9595
0801 9595 F0 03                 beq   AlreadyOnDisk
0802 9597
0803 9597 20 59 9C              jsr   WriteOutScrap
0804 959A
0805 959A AA           AlreadyOnDisk tax   
0806 959B
0807 959B 20 2F 99              jsr   EndScrapCall
0808 959E
0809 959E A0 00 00              ldy   #0
0810 95A1 5C AA FC FE           jml   BusyErr
0811 95A5
0812 95A5
0813 95A5                       ENDP 
0814 95A5
0815 95A5
0816 95A5              ****************************************************************
0817 95A5              *
0818 95A5              * LoadScrap
0819 95A5              *
0820 95A5              *      No parameters.
0821 95A5              *
0822 95A5              * Reads the scrap from disk to memory.  The contents are put
0823 95A5              * into the ScrapHandle.  The file CLIPBOARD is deleted after
0824 95A5              * it is read.
0825 95A5              *
0826 95A5              ****************************************************************
0827 95A5                       ENTRY LoadScrap
0828 95A5              LoadScrap PROC 
0829 95A5
0830 95A5 5A                    phy                            ; save the WAPEntry 
0831 95A6 48                    pha   
0832 95A7
0833 95A7 20 00 99              jsr   StartScrapCall
0834 95AA
0835 95AA A0 32 00              ldy   #ScrapState
0836 95AD B7 1D                 lda   [<MemPtr],y
0837 95AF
0838 95AF F0 05                 beq   YesOnDisk
0839 95B1
0840 95B1 A9 00 00              lda   #0
0841 95B4 80 0A                 bra   AlreadyInMem
0842 95B6
0843 95B6 20 55 9A     YesOnDisk jsr   LoadTheScrap
0844 95B9
0845 95B9 90 05                 bcc   AlreadyInMem             ; no error occured
0846 95BB
0847 95BB C9 46 00              cmp   #FileNotFound
0848 95BE F0 0B                 beq   IgnoreError
0849 95C0
0850 95C0 AA           AlreadyInMem tax   
0851 95C1
0852 95C1 20 2F 99              jsr   EndScrapCall
0853 95C4
0854 95C4 A0 00 00              ldy   #0
0855 95C7 5C AA FC FE           jml   BusyErr
0856 95CB
0857 95CB
0858 95CB A9 00 00     IgnoreError lda   #0
0859 95CE 80 F0                 bra   AlreadyInMem
0860 95D0
0861 95D0                       ENDP 
0862 95D0
0863 95D0
0864 95D0              ****************************************************************
0865 95D0              *
0866 95D0              * ZeroScrap
0867 95D0              *
0868 95D0              *      No parameters.
0869 95D0              *
0870 95D0              * If the scrap exists, it is cleared out.  This means that it
0871 95D0              * disposes the scrap handle if there is one or deletes the
0872 95D0              * CLIPBOARD file if it exists.
0873 95D0              *
0874 95D0              * The scrapCount field of the ScrapInfo record is bumped.
0875 95D0              *
0876 95D0              ****************************************************************
0877 95D0                       ENTRY ZeroScrap
0878 95D0              ZeroScrap PROC 
0879 95D0
0880 95D0 5A                    phy                            ; save the WAPEntry
0881 95D1 48                    pha   
0882 95D2
0883 95D2 20 00 99              jsr   StartScrapCall
0884 95D5
0885 95D5 A0 32 00              ldy   #ScrapState
0886 95D8 B7 1D                 lda   [<MemPtr],y              ; if scrapstate is 0 then scrap is
0887 95DA F0 1A                 beq   ItsOnDisk                ; on disk
0888 95DC
0889 95DC 20 CA 99              jsr   DisposeAllScraps
0890 95DF B0 22                 bcs   ERROR
0891 95E1
0892 95E1 A0 34 00     Finish   ldy   #ScrapCount
0893 95E4 B7 1D                 lda   [<MemPtr],y
0894 95E6 1A                    inc   a
0895 95E7 97 1D                 sta   [<MemPtr],y
0896 95E9
0897 95E9 A2 00 00              ldx   #0
0898 95EC
0899 95EC 20 2F 99     GetOut   jsr   EndScrapCall
0900 95EF
0901 95EF A0 00 00              ldy   #0
0902 95F2 5C AA FC FE           jml   BusyErr
0903 95F6
0904 95F6
0905 95F6              ItsOnDisk  
0906 95F6 20 2B 9A              jsr   DeleteClipboard
0907 95F9
0908 95F9 A9 01 00              lda   #1
0909 95FC A0 32 00              ldy   #ScrapState
0910 95FF 97 1D                 sta   [<MemPtr],y
0911 9601
0912 9601 80 DE                 bra   Finish
0913 9603
0914 9603 AA           ERROR    tax   
0915 9604 80 E6                 bra   GetOut
0916 9606
0917 9606                       ENDP 
0918 9606
0919 9606
0920 9606
0921 9606              ****************************************************************
0922 9606              *
0923 9606              * PutScrap
0924 9606              *
0925 9606              *       Length      : long int
0926 9606              *       type        : integer
0927 9606              *       SourcePtr   : POINTER
0928 9606              *
0929 9606              * Appends user data into the scrap.
0930 9606              *
0931 9606              ****************************************************************
0932 9606                       ENTRY PutScrap
0933 9606              PutScrap PROC 
0934 9606
0935 9606              RTL1     equ   OrigDirect+2+4           ; extra 4 is for the WAPEntry pushed on stack
0936 9606              RTL2     equ   RTL1+3
0937 9606              UserSrcPtr equ   RTL2+3
0938 9606              UserSrcType equ   UserSrcPtr+4
0939 9606              UserSrcLength equ   UserSrcType+2
0940 9606
0941 9606 5A                    phy   
0942 9607 48                    pha   
0943 9608
0944 9608 20 00 99              jsr   StartScrapCall
0945 960B
0946 960B A0 32 00              ldy   #ScrapState
0947 960E B7 1D                 lda   [<MemPtr],y
0948 9610 D0 03                 bne   AlreadyInMem
0949 9612
0950 9612              ;----------------------------------------------------
0951 9612              ;
0952 9612              ; We really don't care if the load fails since
0953 9612              ; it is like loading a empty scrap which we already
0954 9612              ; have.
0955 9612
0956 9612 20 55 9A              jsr   LoadTheScrap
0957 9615
0958 9615              AlreadyInMem  
0959 9615 20 49 99              jsr   DerefFirstHandle
0960 9618
0961 9618 A5 31                 lda   UserSrcType
0962 961A 20 A4 99              jsr   FindThisType
0963 961D
0964 961D B0 03                 bcs   AddThisType
0965 961F 4C BF 96              jmp   FoundType
0966 9622
0967 9622              ;----------------------------------------------------
0968 9622              ;
0969 9622              ; The type is not in the data so I must add it by
0970 9622              ; making the scrap table bigger.
0971 9622              ;
0972 9622 20 6C 99     AddThisType jsr   UnlockFirstHandle
0973 9625
0974 9625 F4 00 00 F4           PushLong #0 
0975 962B A0 30 00              ldy   #FirstScrapHandle+2
0976 962E B7 1D                 lda   [<MemPtr],y
0977 9630 48                    pha   
0978 9631 88                    dey   
0979 9632 88                    dey   
0980 9633 B7 1D                 lda   [<MemPtr],y
0981 9635 48                    pha   
0982 9636 A2 02 18 22           _GetHandleSize 
0983 963D
0984 963D A3 01                 lda   1,s                      ; save a copy of the size of this
0985 963F 85 05                 sta   <OffsetToThisOne         ; thing for use later
0986 9641 A3 03                 lda   3,s
0987 9643 85 07                 sta   <OffsetToThisOne+2
0988 9645
0989 9645 A3 01                 lda   1,s                      ; now add the size of one more
0990 9647 18                    clc                            ; record to this and do a
0991 9648 69 0A 00              adc   #ScrapRecSize            ; set handle size.
0992 964B 83 01                 sta   1,s
0993 964D 90 05                 bcc   NoCarry
0994 964F A3 03                 lda   3,s
0995 9651 1A                    inc   a
0996 9652 83 03                 sta   3,s
0997 9654              NoCarry   
0998 9654
0999 9654 A0 30 00              ldy   #FirstScrapHandle+2
1000 9657 B7 1D                 lda   [<MemPtr],y
1001 9659 48                    pha   
1002 965A 88                    dey   
1003 965B 88                    dey   
1004 965C B7 1D                 lda   [<MemPtr],y
1005 965E 48                    pha   
1006 965F A2 02 19 22           _SetHandleSize 
1007 9666 90 03                 bcc   SizeAdjusted
1008 9668 4C 50 97              jmp   ERROR
1009 966B
1010 966B 20 49 99     SizeAdjusted jsr   DerefFirstHandle     ; deref again
1011 966E
1012 966E A7 01                 lda   [<ScrapTablePtr]         ; bump count of num types in scrap
1013 9670 1A                    inc   a
1014 9671 87 01                 sta   [<ScrapTablePtr]
1015 9673
1016 9673 A5 01                 lda   <ScrapTablePtr           ; now compute the pointer to
1017 9675 18                    clc                            ; the ScrapRec we just made
1018 9676 65 05                 adc   <OffsetToThisOne
1019 9678 85 09                 sta   <PtrToThisOne
1020 967A A5 03                 lda   <ScrapTablePtr+2
1021 967C 65 07                 adc   <OffsetToThisOne+2
1022 967E 85 0B                 sta   <PtrToThisOne+2
1023 9680
1024 9680 A5 31                 lda   UserSrcType              ; put SrcType in recrod
1025 9682 87 09                 sta   [<PtrToThisOne]
1026 9684 A0 02 00              ldy   #o_ScrapSize             ; set size of handle to zero
1027 9687 A9 00 00              lda   #0
1028 968A 97 09                 sta   [<PtrToThisOne],y
1029 968C C8                    iny   
1030 968D C8                    iny   
1031 968E 97 09                 sta   [<PtrToThisOne],y
1032 9690
1033 9690              ;----------------------------------------------------
1034 9690              ;
1035 9690              ; Get a handle of zero size
1036 9690              ;
1037 9690 F4 00 00 F4           PushLong #0                    ; space for handle
1038 9696 F4 00 00 F4           PushLong #0                    ; size 0
1039 969C F4 01 42              PushWord #ScrapUserID 
1040 969F F4 08 00              PushWord #ScrapAttributes 
1041 96A2 F4 00 00 F4           PushLong #0                    ; no loc info
1042 96A8 A2 02 09 22           _Newhandle 
1043 96AF 90 03                 bcc   GotNewHandle
1044 96B1 4C 50 97              jmp   ERROR
1045 96B4
1046 96B4 A0 06 00     GotNewHandle ldy   #o_ScrapHandle
1047 96B7 68                    pla   
1048 96B8 97 09                 sta   [<PtrToThisOne],y
1049 96BA C8                    iny   
1050 96BB C8                    iny   
1051 96BC 68                    pla   
1052 96BD 97 09                 sta   [<PtrToThisOne],y
1053 96BF
1054 96BF              ;----------------------------------------------------
1055 96BF              ;
1056 96BF              ; Type is already in the scrap data so I just need
1057 96BF              ; to append the passed data onto it.
1058 96BF              ;
1059 96BF              FoundType  
1060 96BF
1061 96BF A5 01                 lda   <ScrapTablePtr           ; set or reset PtrToThisOne
1062 96C1 18                    clc                            ; based on OffsetToThisOne
1063 96C2 65 05                 adc   <OffsetToThisOne
1064 96C4 85 09                 sta   <PtrToThisOne
1065 96C6 A5 03                 lda   <ScrapTablePtr+2
1066 96C8 65 07                 adc   <OffsetToThisOne+2
1067 96CA 85 0B                 sta   <PtrToThisOne+2
1068 96CC
1069 96CC A0 02 00              ldy   #o_ScrapSize             ; calculate new handle size
1070 96CF B7 09                 lda   [<PtrToThisOne],y        ; by adding old size to
1071 96D1 18                    clc                            ; SrcLength
1072 96D2 65 33                 adc   UserSrcLength
1073 96D4 AA                    tax   
1074 96D5 C8                    iny   
1075 96D6 C8                    iny   
1076 96D7 B7 09                 lda   [<PtrToThisOne],y
1077 96D9 65 35                 adc   UserSrcLength+2
1078 96DB 48                    pha                            ; push size on stack
1079 96DC DA                    phx   
1080 96DD
1081 96DD A0 08 00              ldy   #o_ScrapHandle+2         ; now get handle from scrap record
1082 96E0 B7 09                 lda   [<PtrToThisOne],y        ; push it and do set handle size
1083 96E2 48                    pha   
1084 96E3 88                    dey   
1085 96E4 88                    dey   
1086 96E5 B7 09                 lda   [<PtrToThisOne],y
1087 96E7 48                    pha   
1088 96E8 A2 02 19 22           _SetHandleSize 
1089 96EF B0 5F                 bcs   ERROR                    ; DAN H. (so will report errors)
1090 96F1
1091 96F1 A0 06 00              ldy   #o_ScrapHandle           ; get handle again from scrap record
1092 96F4 B7 09                 lda   [<PtrToThisOne],y        ; put in dest handle
1093 96F6 85 0D                 sta   <DestHandle              ; and deref it.
1094 96F8 C8                    iny   
1095 96F9 C8                    iny   
1096 96FA B7 09                 lda   [<PtrToThisOne],y
1097 96FC 85 0F                 sta   <DestHandle+2
1098 96FE
1099 96FE 20 84 99              jsr   DerefDest
1100 9701
1101 9701 A5 11                 lda   <DestPtr                 ; figure out where in dest to
1102 9703 A0 02 00              ldy   #o_ScrapSize             ; start adding by adding orig
1103 9706 77 09                 adc   [<PtrToThisOne],y        ; size to DestPtr.
1104 9708 85 11                 sta   <DestPtr
1105 970A A5 13                 lda   <DestPtr+2
1106 970C C8                    iny   
1107 970D C8                    iny   
1108 970E 77 09                 adc   [<PtrToThisOne],y
1109 9710 85 13                 sta   <DestPtr+2
1110 9712
1111 9712              ;----------------------------------------------------
1112 9712              ;
1113 9712              ; Now move it
1114 9712              ;
1115 9712 A5 2F 48 A5           PushLong UserSrcPtr 
1116 9718 A5 13 48 A5           PushLong <DestPtr 
1117 971E A5 35 48 A5           PushLong UserSrcLength 
1118 9724 A2 02 2B 22           _BlockMove 
1119 972B
1120 972B
1121 972B 20 99 99              jsr   UnlockDest
1122 972E
1123 972E
1124 972E              ;----------------------------------------------------
1125 972E              ;
1126 972E              ; Finally, set the scrap size field in the record to
1127 972E              ; the new handle size.
1128 972E
1129 972E 18                    clc   
1130 972F A0 02 00              ldy   #o_ScrapSize             ; and put result size in
1131 9732 B7 09                 lda   [<PtrToThisOne],y        ; scrap record.
1132 9734 65 33                 adc   UserSrcLength
1133 9736 97 09                 sta   [<PtrToThisOne],y
1134 9738 C8                    iny   
1135 9739 C8                    iny   
1136 973A B7 09                 lda   [<PtrToThisOne],y
1137 973C 65 35                 adc   UserSrcLength+2
1138 973E 97 09                 sta   [<PtrToThisOne],y
1139 9740
1140 9740              ;----------------------------------------------------
1141 9740              ;
1142 9740              ; Now unlock First handle
1143 9740              ;
1144 9740 20 6C 99              jsr   UnlockFirstHandle
1145 9743
1146 9743
1147 9743
1148 9743 A2 00 00              ldx   #0                       ; for no error
1149 9746
1150 9746 20 2F 99     GetOut   jsr   EndScrapCall
1151 9749
1152 9749 A0 0A 00              ldy   #10
1153 974C 5C AA FC FE           jml   BusyErr
1154 9750
1155 9750 AA           ERROR    tax   
1156 9751 80 F3                 bra   GetOut
1157 9753
1158 9753                       ENDP 
1159 9753
1160 9753
1161 9753
1162 9753              ****************************************************************
1163 9753              *
1164 9753              * GetScrap
1165 9753              *
1166 9753              *        UserHandle                     (pushed top to bottom)
1167 9753              *        UserType
1168 9753              *
1169 9753              * Copies the scrap to user memory.
1170 9753              *
1171 9753              ****************************************************************
1172 9753                       ENTRY GetScrap
1173 9753              GetScrap PROC 
1174 9753
1175 9753              RTL1     equ   OrigDirect+2+4
1176 9753              RTL2     equ   RTL1+3
1177 9753              UserType equ   RTL2+3
1178 9753              UserHandle equ   UserType+2
1179 9753
1180 9753 5A                    phy                            ; save WAPEntry
1181 9754 48                    pha   
1182 9755
1183 9755 20 00 99              jsr   StartScrapCall
1184 9758
1185 9758 A0 32 00              ldy   #ScrapState
1186 975B B7 1D                 lda   [<MemPtr],y
1187 975D D0 03                 bne   AlreadyInMem
1188 975F
1189 975F              ;----------------------------------------------------
1190 975F              ;
1191 975F              ; We really don't care if the load fails since
1192 975F              ; it is like loading a empty scrap which we already
1193 975F              ; have.
1194 975F              ;
1195 975F 20 55 9A              jsr   LoadTheScrap
1196 9762
1197 9762
1198 9762              AlreadyInMem  
1199 9762 20 49 99              jsr   DerefFirstHandle
1200 9765
1201 9765 A5 2D                 lda   UserType
1202 9767 20 A4 99              jsr   FindThisType
1203 976A 90 05                 bcc   FoundType
1204 976C
1205 976C A9 10 16              lda   #TypeError
1206 976F 80 5A                 bra   ERROR
1207 9771
1208 9771              ;----------------------------------------------------
1209 9771              ;
1210 9771              ; Type is already in the scrap data so I just need
1211 9771              ; to append the passed data onto it.
1212 9771              ;
1213 9771              FoundType  
1214 9771
1215 9771 A5 01                 lda   <ScrapTablePtr           ; set or reset PtrToThisOne
1216 9773 18                    clc                            ; based on OffsetToThisOne
1217 9774 65 05                 adc   <OffsetToThisOne
1218 9776 85 09                 sta   <PtrToThisOne
1219 9778 A5 07                 lda   <OffsetToThisOne+2
1220 977A 65 03                 adc   <ScrapTablePtr+2
1221 977C 85 0B                 sta   <PtrToThisOne+2
1222 977E
1223 977E A0 04 00              ldy   #o_ScrapSize+2           ; get size handle will be
1224 9781 B7 09                 lda   [<PtrToThisOne],y        ; and set user handle to this
1225 9783 48                    pha                            ; size
1226 9784 88                    dey   
1227 9785 88                    dey   
1228 9786 B7 09                 lda   [<PtrToThisOne],y
1229 9788 48                    pha   
1230 9789 A5 31 48 A5           PushLong UserHandle 
1231 978F A2 02 19 22           _SetHandleSize 
1232 9796
1233 9796 B0 33                 bcs   ERROR
1234 9798
1235 9798
1236 9798 A0 08 00              ldy   #o_ScrapHandle+2         ; now use handle to handle to make
1237 979B B7 09                 lda   [<PtrToThisOne],y        ; copy.
1238 979D 48                    pha   
1239 979E 88                    dey   
1240 979F 88                    dey   
1241 97A0 B7 09                 lda   [<PtrToThisOne],y
1242 97A2 48                    pha   
1243 97A3 A5 31 48 A5           PushLong UserHandle 
1244 97A9 A0 04 00              ldy   #o_ScrapSize+2
1245 97AC B7 09                 lda   [<PtrToThisOne],y
1246 97AE 48                    pha   
1247 97AF 88                    dey   
1248 97B0 88                    dey   
1249 97B1 B7 09                 lda   [<PtrToThisOne],y
1250 97B3 48                    pha   
1251 97B4 A2 02 2A 22           _HandToHand 
1252 97BB
1253 97BB 20 6C 99              jsr   UnlockFirstHandle
1254 97BE
1255 97BE A2 00 00              ldx   #0                       ; for no error
1256 97C1
1257 97C1 20 2F 99     GetOut   jsr   EndScrapCall
1258 97C4
1259 97C4 A0 06 00              ldy   #6
1260 97C7 5C AA FC FE           jml   BusyErr
1261 97CB
1262 97CB AA           ERROR    tax   
1263 97CC 80 F3                 bra   GetOut
1264 97CE
1265 97CE                       ENDP 
1266 97CE
1267 97CE
1268 97CE              ****************************************************************
1269 97CE              *
1270 97CE              * GetScrapHandle
1271 97CE              *
1272 97CE              *              Space For Handle
1273 97CE              *              ScrapType
1274 97CE              *
1275 97CE              * Returns the handle to the scrap of the specified type.  We
1276 97CE              * provide this so that the user does not have to make a copy of
1277 97CE              * what is in the scrap to "Get" it.
1278 97CE              *
1279 97CE              ****************************************************************
1280 97CE                       ENTRY GetScrapHandle
1281 97CE              GetScrapHandle PROC 
1282 97CE
1283 97CE              RTL1     equ   OrigDirect+2+4
1284 97CE              RTL2     equ   RTL1+3
1285 97CE              UserType equ   RTL2+3
1286 97CE              UserHandle equ   UserType+2
1287 97CE
1288 97CE 5A                    phy   
1289 97CF 48                    pha   
1290 97D0
1291 97D0 20 00 99              jsr   StartScrapCall
1292 97D3
1293 97D3 A0 32 00              ldy   #ScrapState
1294 97D6 B7 1D                 lda   [<MemPtr],y
1295 97D8 D0 03                 bne   AlreadyInMem
1296 97DA
1297 97DA              ;----------------------------------------------------
1298 97DA              ;
1299 97DA              ; We really don't care if the load fails since
1300 97DA              ; it is like loading a empty scrap which we already
1301 97DA              ; have.
1302 97DA              ;
1303 97DA 20 55 9A              jsr   LoadTheScrap
1304 97DD
1305 97DD              AlreadyInMem  
1306 97DD 20 49 99              jsr   DerefFirstHandle
1307 97E0
1308 97E0 A5 2D                 lda   UserType
1309 97E2 20 A4 99              jsr   FindThisType
1310 97E5 90 05                 bcc   FoundType
1311 97E7
1312 97E7 A9 10 16              lda   #TypeError
1313 97EA 80 2C                 bra   ERROR
1314 97EC
1315 97EC
1316 97EC              FoundType  
1317 97EC
1318 97EC A5 01                 lda   <ScrapTablePtr           ; set or reset PtrToThisOne
1319 97EE 18                    clc                            ; based on OffsetToThisOne
1320 97EF 65 05                 adc   <OffsetToThisOne
1321 97F1 85 09                 sta   <PtrToThisOne
1322 97F3 A5 07                 lda   <OffsetToThisOne+2
1323 97F5 65 03                 adc   <ScrapTablePtr+2
1324 97F7 85 0B                 sta   <PtrToThisOne+2
1325 97F9
1326 97F9 A0 06 00              ldy   #o_ScrapHandle           ; get handle
1327 97FC B7 09                 lda   [<PtrToThisOne],y
1328 97FE 85 2F                 sta   UserHandle
1329 9800 C8                    iny   
1330 9801 C8                    iny   
1331 9802 B7 09                 lda   [<PtrToThisOne],y
1332 9804 85 31                 sta   UserHandle+2
1333 9806
1334 9806 A2 00 00              ldx   #0                       ; for no error
1335 9809
1336 9809 DA           GetOut   phx   
1337 980A 20 6C 99              jsr   UnlockFirstHandle
1338 980D FA                    plx   
1339 980E
1340 980E 20 2F 99              jsr   EndScrapCall
1341 9811
1342 9811 A0 02 00              ldy   #2
1343 9814 5C AA FC FE           jml   BusyErr
1344 9818
1345 9818 AA           ERROR    tax   
1346 9819 80 EE                 bra   GetOut
1347 981B
1348 981B                       ENDP 
1349 981B
1350 981B
1351 981B              ****************************************************************
1352 981B              *
1353 981B              * GetScrapSize
1354 981B              *
1355 981B              *              Space For Size
1356 981B              *              ScrapType
1357 981B              *
1358 981B              * Returns the size of the scrap of the specified type.
1359 981B              *
1360 981B              ****************************************************************
1361 981B                       ENTRY GetScrapSize
1362 981B              GetScrapSize PROC 
1363 981B
1364 981B              RTL1     equ   OrigDirect+2+4
1365 981B              RTL2     equ   RTL1+3
1366 981B              UserType equ   RTL2+3
1367 981B              UserSize equ   UserType+2
1368 981B
1369 981B 5A                    phy   
1370 981C 48                    pha   
1371 981D
1372 981D 20 00 99              jsr   StartScrapCall
1373 9820
1374 9820 A0 32 00              ldy   #ScrapState
1375 9823 B7 1D                 lda   [<MemPtr],y
1376 9825 D0 03                 bne   AlreadyInMem
1377 9827
1378 9827              ;----------------------------------------------------
1379 9827              ;
1380 9827              ; We really don't care if the load fails since
1381 9827              ; it is like loading a empty scrap which we already
1382 9827              ; have.
1383 9827              ;
1384 9827 20 55 9A              jsr   LoadTheScrap
1385 982A
1386 982A              AlreadyInMem  
1387 982A 20 49 99              jsr   DerefFirstHandle
1388 982D
1389 982D A5 2D                 lda   UserType
1390 982F 20 A4 99              jsr   FindThisType
1391 9832 90 05                 bcc   FoundType
1392 9834
1393 9834 A9 10 16              lda   #TypeError
1394 9837 80 2C                 bra   ERROR
1395 9839
1396 9839 A5 01        FoundType lda   <ScrapTablePtr          ; set or reset PtrToThisOne
1397 983B 18                    clc                            ; based on OffsetToThisOne
1398 983C 65 05                 adc   <OffsetToThisOne
1399 983E 85 09                 sta   <PtrToThisOne
1400 9840 A5 07                 lda   <OffsetToThisOne+2
1401 9842 65 03                 adc   <ScrapTablePtr+2
1402 9844 85 0B                 sta   <PtrToThisOne+2
1403 9846
1404 9846 A0 02 00              ldy   #o_ScrapSize             ; get size
1405 9849 B7 09                 lda   [<PtrToThisOne],y
1406 984B 85 2F                 sta   UserSize
1407 984D C8                    iny   
1408 984E C8                    iny   
1409 984F B7 09                 lda   [<PtrToThisOne],y
1410 9851 85 31                 sta   UserSize+2
1411 9853
1412 9853 A2 00 00              ldx   #0                       ; for no error
1413 9856
1414 9856 DA           GetOut   phx   
1415 9857 20 6C 99              jsr   UnlockFirstHandle
1416 985A FA                    plx   
1417 985B
1418 985B 20 2F 99              jsr   EndScrapCall
1419 985E
1420 985E A0 02 00              ldy   #2
1421 9861 5C AA FC FE           jml   BusyErr
1422 9865
1423 9865 AA           ERROR    tax   
1424 9866 80 EE                 bra   GetOut
1425 9868
1426 9868                       ENDP 
1427 9868
1428 9868
1429 9868              ****************************************************************
1430 9868              *
1431 9868              * GetScrapPath
1432 9868              *
1433 9868              *              No inputs
1434 9868              *
1435 9868              * Returns a pointer to the path name string used by the
1436 9868              * clipboard.
1437 9868              *
1438 9868              ****************************************************************
1439 9868                       ENTRY GetScrapPath
1440 9868              GetScrapPath PROC 
1441 9868
1442 9868              OrigD    equ   1
1443 9868              WAPPointer equ   OrigD+2
1444 9868              RTL1     equ   WAPPointer+4
1445 9868              RTL2     equ   RTL1+3
1446 9868              PathPtr  equ   RTL2+3
1447 9868
1448 9868 5A                    phy                            ; save WAPEntry
1449 9869 48                    pha   
1450 986A 0B                    phd                            ; save direct page
1451 986B
1452 986B 3B                    tsc   
1453 986C 5B                    tcd                            ; make stack the direct page
1454 986D
1455 986D A0 02 00              ldy   #2                       ; dereference WAPEntry
1456 9870 B7 03                 lda   [<WAPPointer],y
1457 9872 AA                    tax   
1458 9873 A7 03                 lda   [<WAPPointer]
1459 9875 85 03                 sta   <WAPPointer
1460 9877 8A                    txa   
1461 9878 85 05                 sta   <WAPPointer+2
1462 987A
1463 987A A0 3A 00              ldy   #ScrapName
1464 987D B7 03                 lda   [<WAPPointer],y
1465 987F 85 0D                 sta   <PathPtr
1466 9881 C8                    iny   
1467 9882 C8                    iny   
1468 9883 B7 03                 lda   [<WAPPointer],y
1469 9885 85 0F                 sta   <PathPtr+2
1470 9887
1471 9887 2B                    pld                            ; restore original direct page
1472 9888
1473 9888 68                    pla                            ; get rid of WAPPointer
1474 9889 68                    pla   
1475 988A
1476 988A A0 00 00              ldy   #0
1477 988D 5C ED FC FE           jml   oEndCall
1478 9891
1479 9891                       ENDP 
1480 9891
1481 9891
1482 9891
1483 9891              ****************************************************************
1484 9891              *
1485 9891              * SetScrapPath
1486 9891              *
1487 9891              *              Ptr to New Path
1488 9891              *
1489 9891              * Sets the pointer to the path name string used by the
1490 9891              * clipboard.
1491 9891              *
1492 9891              ****************************************************************
1493 9891                       ENTRY SetScrapPath
1494 9891              SetScrapPath PROC 
1495 9891
1496 9891              OrigD    equ   1
1497 9891              WAPPointer equ   OrigD+2
1498 9891              RTL1     equ   WAPPointer+4
1499 9891              RTL2     equ   RTL1+3
1500 9891              PathPtr  equ   RTL2+3
1501 9891
1502 9891 5A                    phy                            ; save WAPEntry
1503 9892 48                    pha   
1504 9893 0B                    phd                            ; save direct page
1505 9894
1506 9894 3B                    tsc   
1507 9895 5B                    tcd                            ; make stack the direct page
1508 9896
1509 9896 A0 02 00              ldy   #2                       ; dereference WAPEntry
1510 9899 B7 03                 lda   [<WAPPointer],y
1511 989B AA                    tax   
1512 989C A7 03                 lda   [<WAPPointer]
1513 989E 85 03                 sta   <WAPPointer
1514 98A0 8A                    txa   
1515 98A1 85 05                 sta   <WAPPointer+2
1516 98A3
1517 98A3 A5 0D                 lda   <PathPtr
1518 98A5 A0 3A 00              ldy   #ScrapName
1519 98A8 97 03                 sta   [<WAPPointer],y
1520 98AA A5 0F                 lda   <PathPtr+2
1521 98AC C8                    iny   
1522 98AD C8                    iny   
1523 98AE 97 03                 sta   [<WAPPointer],y
1524 98B0
1525 98B0 2B                    pld                            ; restore original direct page
1526 98B1
1527 98B1 68                    pla                            ; get rid of WAPPointer off stack
1528 98B2 68                    pla   
1529 98B3
1530 98B3 A0 04 00              ldy   #4
1531 98B6 5C ED FC FE           jml   oendcall
1532 98BA
1533 98BA                       ENDP 
1534 98BA
1535 98BA
1536 98BA              ****************************************************************
1537 98BA              *
1538 98BA              * GetScrapCount
1539 98BA              *
1540 98BA              *              Space for count
1541 98BA              *
1542 98BA              * Returns the global variable scrap count
1543 98BA              *
1544 98BA              ****************************************************************
1545 98BA                       ENTRY GetScrapCount
1546 98BA              GetScrapCount PROC 
1547 98BA
1548 98BA              OrigD    equ   1
1549 98BA              WAPPointer equ   OrigD+2
1550 98BA              RTL1     equ   WAPPointer+4
1551 98BA              RTL2     equ   RTL1+3
1552 98BA              Result   equ   RTL2+3
1553 98BA
1554 98BA 5A                    phy                            ; save WAPEntry
1555 98BB 48                    pha   
1556 98BC 0B                    phd                            ; save direct page
1557 98BD
1558 98BD 3B                    tsc   
1559 98BE 5B                    tcd                            ; make stack the direct page
1560 98BF
1561 98BF A0 02 00              ldy   #2                       ; dereference WAPEntry
1562 98C2 B7 03                 lda   [<WAPPointer],y
1563 98C4 AA                    tax   
1564 98C5 A7 03                 lda   [<WAPPointer]
1565 98C7 85 03                 sta   <WAPPointer
1566 98C9 8A                    txa   
1567 98CA 85 05                 sta   <WAPPointer+2
1568 98CC
1569 98CC A0 34 00              ldy   #ScrapCount
1570 98CF B7 03                 lda   [<WAPPointer],y
1571 98D1 85 0D                 sta   <Result
1572 98D3
1573 98D3 2B                    pld                            ; restore original direct page
1574 98D4
1575 98D4 68                    pla                            ; get rid of WAPPointer on stack
1576 98D5 68                    pla   
1577 98D6
1578 98D6 A0 00 00              ldy   #0
1579 98D9 5C ED FC FE           jml   oEndCall
1580 98DD
1581 98DD                       ENDP 
1582 98DD
1583 98DD
1584 98DD              ****************************************************************
1585 98DD              *
1586 98DD              * GetScrapState
1587 98DD              *
1588 98DD              *              Space for count
1589 98DD              *
1590 98DD              * Returns the global variable scrap count
1591 98DD              *
1592 98DD              ****************************************************************
1593 98DD                       ENTRY GetScrapState
1594 98DD              GetScrapState PROC 
1595 98DD
1596 98DD              OrigD    equ   1
1597 98DD              WAPPointer equ   OrigD+2
1598 98DD              RTL1     equ   WAPPointer+4
1599 98DD              RTL2     equ   RTL1+3
1600 98DD              Result   equ   RTL2+3
1601 98DD
1602 98DD 5A                    phy                            ; save WAPEntry
1603 98DE 48                    pha   
1604 98DF 0B                    phd                            ; save direct page
1605 98E0
1606 98E0 3B                    tsc   
1607 98E1 5B                    tcd                            ; make stack the direct page
1608 98E2
1609 98E2 A0 02 00              ldy   #2                       ; dereference WAPEntry
1610 98E5 B7 03                 lda   [<WAPPointer],y
1611 98E7 AA                    tax   
1612 98E8 A7 03                 lda   [<WAPPointer]
1613 98EA 85 03                 sta   <WAPPointer
1614 98EC 8A                    txa   
1615 98ED 85 05                 sta   <WAPPointer+2
1616 98EF
1617 98EF A0 32 00              ldy   #ScrapState
1618 98F2 B7 03                 lda   [<WAPPointer],y
1619 98F4 85 0D                 sta   <Result
1620 98F6
1621 98F6 2B                    pld                            ; restore original direct page
1622 98F7
1623 98F7 68                    pla                            ; get rid of WAPPointer on stack
1624 98F8 68                    pla   
1625 98F9
1626 98F9 A0 00 00              ldy   #0
1627 98FC 5C ED FC FE           jml   oEndCall
1628 9900
1629 9900                       ENDP 
1630 9900
1631 9900
1632 9900              ****************************************************************
1633 9900              ****************************************************************
1634 9900              *
1635 9900              * StartScrapCall
1636 9900              *
1637 9900              * This routine sets up direct page, adjusts the stack and
1638 9900              * data bank, calls inc busy flag in preparation for the
1639 9900              * start of a Scrap Manager call.
1640 9900              *
1641 9900              ****************************************************************
1642 9900                       ENTRY StartScrapCall
1643 9900              StartScrapCall PROC 
1644 9900
1645 9900 7A                    ply                            ; get rts addr in y
1646 9901
1647 9901 0B                    phd                            ; save direct reg
1648 9902 3B                    tsc                            ; and get my zero page off stack
1649 9903 38                    sec   
1650 9904 E9 20 00              sbc   #StdZPSize
1651 9907 1B                    tcs   
1652 9908 5B                    tcd   
1653 9909
1654 9909 8B                    phb                            ; save data bank
1655 990A 4B                    phk                            ; set data bank to
1656 990B AB                    plb                            ; code bank
1657 990C
1658 990C A3 24                 lda   StdZPSize+4,s
1659 990E 85 19                 sta   <MemHandle
1660 9910 A3 26                 lda   StdZPSize+6,s
1661 9912 85 1B                 sta   <MemHandle+2
1662 9914
1663 9914 5A                    phy                            ; put rts back on the stack
1664 9915
1665 9915 A0 04 00              ldy   #4                       ; deref and lock MemHandle
1666 9918 B7 19                 lda   [<MemHandle],y
1667 991A 09 00 80              ora   #$8000
1668 991D 97 19                 sta   [<MemHandle],y
1669 991F 88                    dey   
1670 9920 88                    dey   
1671 9921 B7 19                 lda   [<MemHandle],y
1672 9923 AA                    tax   
1673 9924 A7 19                 lda   [<MemHandle]
1674 9926 85 1D                 sta   <MemPtr
1675 9928 86 1F                 stx   <MemPtr+2
1676 992A
1677 992A 22 64 00 E1           jsl   IncBusyFlg
1678 992E
1679 992E 60                    rts   
1680 992F
1681 992F                       ENDP 
1682 992F
1683 992F
1684 992F              ****************************************************************
1685 992F              *
1686 992F              * EndScrapCall
1687 992F              *
1688 992F              * This routine restores direct page and data bank, and adjusts
1689 992F              * adjusts the stack to undo everything that startScrapCall
1690 992F              * did.
1691 992F              *
1692 992F              * Note:  DecBusyFlg is done by the end call routine.
1693 992F              *
1694 992F              ****************************************************************
1695 992F                       ENTRY EndScrapCall
1696 992F              EndScrapCall PROC 
1697 992F
1698 992F A0 04 00              ldy   #4                       ; unlock MemHandle
1699 9932 B7 19                 lda   [<MemHandle],y
1700 9934 29 FF 7F              and   #$7FFF
1701 9937 97 19                 sta   [<MemHandle],y
1702 9939
1703 9939 7A                    ply                            ; save rts addr in y
1704 993A
1705 993A AB                    plb   
1706 993B 3B                    tsc   
1707 993C 18                    clc   
1708 993D 69 20 00              adc   #StdZPSize
1709 9940 1B                    tcs   
1710 9941
1711 9941 A3 01                 lda   1,s                      ; save direct page
1712 9943 83 05                 sta   5,s                      ; overwrite the high word of WAPEntry on stack
1713 9945 68                    pla                            ; get rid of direct page still on stack
1714 9946 68                    pla                            ; get rid of low word of WAPEntry
1715 9947 5A                    phy                            ; put rts back on stack
1716 9948
1717 9948 60                    rts   
1718 9949
1719 9949                       ENDP 
1720 9949
1721 9949
1722 9949              ****************************************************************
1723 9949              *
1724 9949              * Scrap Utility Routines
1725 9949              *
1726 9949              ****************************************************************
1727 9949
1728 9949                       ENTRY DerefFirstHandle
1729 9949              DerefFirstHandle PROC 
1730 9949
1731 9949 A0 2E 00              ldy   #FirstScrapHandle
1732 994C B7 1D                 lda   [<MemPtr],y
1733 994E 85 01                 sta   <ScrapTablePtr
1734 9950 C8                    iny   
1735 9951 C8                    iny   
1736 9952 B7 1D                 lda   [<MemPtr],y
1737 9954 85 03                 sta   <ScrapTablePtr+2
1738 9956
1739 9956 A0 04 00              ldy   #4
1740 9959 B7 01                 lda   [<ScrapTablePtr],y
1741 995B 09 00 80              ora   #$8000
1742 995E 97 01                 sta   [<ScrapTablePtr],y
1743 9960 88                    dey   
1744 9961 88                    dey   
1745 9962 B7 01                 lda   [<ScrapTablePtr],y
1746 9964 AA                    tax   
1747 9965 A7 01                 lda   [<ScrapTablePtr]
1748 9967 85 01                 sta   <ScrapTablePtr
1749 9969 86 03                 stx   <ScrapTablePtr+2
1750 996B
1751 996B 60                    rts   
1752 996C
1753 996C                       ENDP 
1754 996C
1755 996C
1756 996C                       ENTRY UnlockFirstHandle
1757 996C              UnlockFirstHandle PROC 
1758 996C
1759 996C A0 2E 00              ldy   #FirstScrapHandle
1760 996F B7 1D                 lda   [<MemPtr],y
1761 9971 85 01                 sta   <ScrapTablePtr
1762 9973 C8                    iny   
1763 9974 C8                    iny   
1764 9975 B7 1D                 lda   [<MemPtr],y
1765 9977 85 03                 sta   <ScrapTablePtr+2
1766 9979
1767 9979 A0 04 00              ldy   #4
1768 997C B7 01                 lda   [<ScrapTablePtr],y
1769 997E 29 FF 7F              and   #$7FFF
1770 9981 97 01                 sta   [<ScrapTablePtr],y
1771 9983
1772 9983 60                    rts   
1773 9984
1774 9984                       ENDP 
1775 9984
1776 9984
1777 9984                       ENTRY DerefDest
1778 9984              DerefDest PROC 
1779 9984
1780 9984 A0 04 00              ldy   #4
1781 9987 B7 0D                 lda   [<DestHandle],y
1782 9989 09 00 80              ora   #$8000
1783 998C 97 0D                 sta   [<DestHandle],y
1784 998E 88                    dey   
1785 998F 88                    dey   
1786 9990 B7 0D                 lda   [<DestHandle],y
1787 9992 85 13                 sta   <DestPtr+2
1788 9994 A7 0D                 lda   [<DestHandle]
1789 9996 85 11                 sta   <DestPtr
1790 9998
1791 9998 60                    rts   
1792 9999
1793 9999                       ENDP 
1794 9999
1795 9999
1796 9999                       ENTRY UnlockDest
1797 9999              UnlockDest PROC 
1798 9999
1799 9999 A0 04 00              ldy   #4
1800 999C B7 0D                 lda   [<DestHandle],y
1801 999E 29 FF 7F              and   #$7FFF
1802 99A1 97 0D                 sta   [<DestHandle],y
1803 99A3
1804 99A3 60                    rts   
1805 99A4
1806 99A4                       ENDP 
1807 99A4
1808 99A4
1809 99A4              ****************************************************************
1810 99A4              *
1811 99A4              * FindThisType
1812 99A4              *
1813 99A4              * We search through the scrap table for a scrap record of
1814 99A4              * the type passed in the a register.
1815 99A4              *
1816 99A4              * If we find it, we return with the carry clear and the
1817 99A4              * variable OffsetToThisOne set on zero page.
1818 99A4              *
1819 99A4              * If we do not find it we return with carry set.
1820 99A4              *
1821 99A4              ****************************************************************
1822 99A4                       ENTRY FindThisType
1823 99A4              FindThisType PROC 
1824 99A4
1825 99A4 48                    pha                            ; store the type to find on the stack
1826 99A5
1827 99A5 A0 02 00              ldy   #2                       ; y points to first scrap record
1828 99A8 A2 01 00              ldx   #1                       ; x is count
1829 99AB
1830 99AB              KeepLooking                             ;
1831 99AB 8A                    txa                            ; compare count to num scrap records
1832 99AC C7 01                 cmp   [<ScrapTablePtr]
1833 99AE F0 02                 beq   LastItem
1834 99B0 B0 16                 bcs   NotInTable
1835 99B2
1836 99B2 B7 01        LastItem lda   [<ScrapTablePtr],y       ; get the type of this scrap record
1837 99B4 C3 01                 cmp   1,s                      ; compare to value on stack
1838 99B6 F0 09                 beq   FoundIt
1839 99B8
1840 99B8 98                    tya                            ; bump y by size of record
1841 99B9 18                    clc   
1842 99BA 69 0A 00              adc   #ScrapRecSize
1843 99BD A8                    tay   
1844 99BE E8                    inx                            ; bump count by 1
1845 99BF 80 EA                 bra   KeepLooking
1846 99C1
1847 99C1
1848 99C1 68           FoundIt  pla                            ; carry is clear here
1849 99C2 84 05                 sty   <OffsetToThisOne
1850 99C4 64 07                 stz   <OffsetToThisOne+2
1851 99C6 18                    clc   
1852 99C7 60                    rts   
1853 99C8
1854 99C8 68           NotInTable pla                          ; carry is set here
1855 99C9 60                    rts   
1856 99CA
1857 99CA                       ENDP 
1858 99CA
1859 99CA
1860 99CA                       eject 
1861 99CA              ****************************************************************
1862 99CA              *
1863 99CA              * DisposeAllScraps
1864 99CA              *
1865 99CA              * Traverses through the scrap table disposing of all the
1866 99CA              * handles in each scrap record.
1867 99CA              *
1868 99CA              * The ScrapTablePtr must already be setup on zero page
1869 99CA              * when this is called.
1870 99CA              *
1871 99CA              ****************************************************************
1872 99CA                       ENTRY DisposeAllScraps
1873 99CA              DisposeAllScraps PROC 
1874 99CA
1875 99CA 20 49 99              jsr   DerefFirstHandle
1876 99CD
1877 99CD A0 08 00              ldy   #2+o_ScrapHandle         ; y points to first scrap record
1878 99D0 A2 00 00              ldx   #0                       ; x is count, DAN H. (to do last one)
1879 99D3
1880 99D3              KeepLooking                             ;
1881 99D3 8A                    txa                            ; compare count to num scrap records
1882 99D4 C7 01                 cmp   [<ScrapTablePtr]
1883 99D6 B0 26                 bcs   TableComplete
1884 99D8
1885 99D8 DA                    phx                            ; save x and y
1886 99D9 5A                    phy   
1887 99DA F4 00 00              pea   0
1888 99DD F4 00 00              pea   0
1889 99E0 B7 01                 lda   [<ScrapTablePtr],y       ; get the type of this scrap record
1890 99E2 83 01                 sta   1,s
1891 99E4 C8                    iny   
1892 99E5 C8                    iny   
1893 99E6 B7 01                 lda   [<ScrapTablePtr],y
1894 99E8 83 03                 sta   3,s
1895 99EA
1896 99EA A2 02 10 22           _Disposehandle 
1897 99F1 B0 35                 bcs   ERROR
1898 99F3
1899 99F3 7A                    ply                            ; get back x and y
1900 99F4 FA                    plx   
1901 99F5
1902 99F5 98                    tya                            ; bump y by size of record
1903 99F6 18                    clc   
1904 99F7 69 0A 00              adc   #ScrapRecSize
1905 99FA A8                    tay   
1906 99FB E8                    inx                            ; bump count by 1
1907 99FC 80 D5                 bra   KeepLooking
1908 99FE
1909 99FE
1910 99FE              TableComplete  
1911 99FE
1912 99FE 20 6C 99              jsr   UnlockFirstHandle
1913 9A01
1914 9A01 F4 00 00 F4           PushLong #2 
1915 9A07 A0 30 00              ldy   #FirstScrapHandle+2
1916 9A0A B7 1D                 lda   [<MemPtr],y
1917 9A0C 48                    pha   
1918 9A0D 88                    dey   
1919 9A0E 88                    dey   
1920 9A0F B7 1D                 lda   [<MemPtr],y
1921 9A11 48                    pha   
1922 9A12 A2 02 19 22           _SetHandleSize 
1923 9A19 B0 0F                 bcs   ERROR2
1924 9A1B
1925 9A1B 20 49 99              jsr   DerefFirstHandle
1926 9A1E A9 00 00              lda   #0
1927 9A21 87 01                 sta   [<ScrapTablePtr]
1928 9A23 20 6C 99              jsr   UnlockFirstHandle
1929 9A26
1930 9A26 18                    clc   
1931 9A27 60                    rts   
1932 9A28
1933 9A28 7A           ERROR    ply   
1934 9A29 FA                    plx   
1935 9A2A 60           ERROR2   rts   
1936 9A2B
1937 9A2B                       ENDP 
1938 9A2B
1939 9A2B
1940 9A2B                       eject 
1941 9A2B              ****************************************************************
1942 9A2B              *
1943 9A2B              * DeleteClipboard
1944 9A2B              *
1945 9A2B              * Deletes the clipboard file (if it exists).
1946 9A2B              *
1947 9A2B              ****************************************************************
1948 9A2B                       ENTRY DeleteClipBoard
1949 9A2B              DeleteClipBoard PROC 
1950 9A2B
1951 9A2B A0 3A 00              ldy   #ScrapName
1952 9A2E B7 1D                 lda   [<MemPtr],y
1953 9A30 A0 20 00              ldy   #DestroyPath
1954 9A33 97 1D                 sta   [<MemPtr],y
1955 9A35 A0 3C 00              ldy   #ScrapName+2
1956 9A38 B7 1D                 lda   [<MemPtr],y
1957 9A3A A0 22 00              ldy   #DestroyPath+2
1958 9A3D 97 1D                 sta   [<MemPtr],y
1959 9A3F
1960 9A3F A5 1D                 lda   <MemPtr
1961 9A41 18                    clc   
1962 9A42 69 20 00              adc   #DestroyParams
1963 9A45 AA                    tax   
1964 9A46 A5 1F                 lda   <MemPtr+2
1965 9A48 69 00 00              adc   #0
1966 9A4B 48                    pha   
1967 9A4C DA                    phx   
1968 9A4D
1969 9A4D F4 02 00              pea   DestroyCall
1970 9A50 22 B0 00 E1           jsl   StackProDOS
1971 9A54
1972 9A54 60                    rts   
1973 9A55
1974 9A55                       ENDP 
1975 9A55
1976 9A55
1977 9A55                       eject 
1978 9A55              ****************************************************************
1979 9A55              *
1980 9A55              * LoadTheScrap
1981 9A55              *
1982 9A55              * Loads the scrap from the clipboard file and creates the
1983 9A55              * appropriate scrap table in memory.
1984 9A55              *
1985 9A55              *
1986 9A55              * The scrap is read into memory as follows:
1987 9A55              *
1988 9A55              *      First, the ScrapTable is read from disk as is (this
1989 9A55              *      includes the handles which are no longer valid but
1990 9A55              *      serve as place holders).
1991 9A55              *
1992 9A55              *      Then each scrap is read out.
1993 9A55              *
1994 9A55              ****************************************************************
1995 9A55                       ENTRY LoadTheScrap
1996 9A55              LoadTheScrap PROC 
1997 9A55
1998 9A55              ;----------------------------------------------------
1999 9A55              ;
2000 9A55              ; Open the file and copy the ID's
2001 9A55              ;
2002 9A55 A0 3A 00              ldy   #ScrapName
2003 9A58 B7 1D                 lda   [<MemPtr],y
2004 9A5A A0 02 00              ldy   #OpenPath
2005 9A5D 97 1D                 sta   [<MemPtr],y
2006 9A5F A0 3C 00              ldy   #ScrapName+2
2007 9A62 B7 1D                 lda   [<MemPtr],y
2008 9A64 A0 04 00              ldy   #OpenPath+2
2009 9A67 97 1D                 sta   [<MemPtr],y
2010 9A69
2011 9A69 A5 1D                 lda   <MemPtr
2012 9A6B 18                    clc   
2013 9A6C 69 00 00              adc   #OpenParams
2014 9A6F AA                    tax   
2015 9A70 A5 1F                 lda   <MemPtr+2
2016 9A72 69 00 00              adc   #0
2017 9A75 48                    pha   
2018 9A76 DA                    phx   
2019 9A77
2020 9A77 F4 10 00              pea   OpenCall
2021 9A7A 22 B0 00 E1           jsl   StackProDOS
2022 9A7E
2023 9A7E 90 03                 bcc   OpenOK
2024 9A80 4C 92 9B              jmp   ERROR
2025 9A83
2026 9A83              OpenOK    
2027 9A83
2028 9A83              ;----------------------------------------------------
2029 9A83              ;
2030 9A83              ; Read in the number of entries in the scrap table
2031 9A83              ;
2032 9A83 A5 1D                 lda   <MemPtr
2033 9A85 18                    clc   
2034 9A86 69 2C 00              adc   #NumEntries
2035 9A89 A0 02 00              ldy   #ReadTo
2036 9A8C 97 1D                 sta   [<MemPtr],y
2037 9A8E
2038 9A8E A5 1F                 lda   <MemPtr+2
2039 9A90 69 00 00              adc   #0
2040 9A93 C8                    iny   
2041 9A94 C8                    iny   
2042 9A95 97 1D                 sta   [<MemPtr],y
2043 9A97
2044 9A97 A9 02 00              lda   #2
2045 9A9A A0 06 00              ldy   #ReadAmount
2046 9A9D 97 1D                 sta   [<MemPtr],y
2047 9A9F C8                    iny   
2048 9AA0 C8                    iny   
2049 9AA1 A9 00 00              lda   #0
2050 9AA4 97 1D                 sta   [<MemPtr],y
2051 9AA6
2052 9AA6 A5 1D                 lda   <MemPtr
2053 9AA8 18                    clc   
2054 9AA9 69 00 00              adc   #ReadParams
2055 9AAC AA                    tax   
2056 9AAD A5 1F                 lda   <MemPtr+2
2057 9AAF 69 00 00              adc   #0
2058 9AB2 48                    pha   
2059 9AB3 DA                    phx   
2060 9AB4
2061 9AB4 F4 12 00              pea   ReadCall
2062 9AB7 22 B0 00 E1           jsl   StackProDOS
2063 9ABB
2064 9ABB 90 03                 bcc   ReadOK
2065 9ABD
2066 9ABD 4C 92 9B              jmp   ERROR
2067 9AC0              ReadOK    
2068 9AC0
2069 9AC0              ;----------------------------------------------------
2070 9AC0              ;
2071 9AC0              ; Calculate the size of the scrap table record.
2072 9AC0              ; and how much more needs to be read.
2073 9AC0              ;
2074 9AC0 F4 00 00 F4           PushLong #0 
2075 9AC6 A0 2C 00              ldy   #NumEntries
2076 9AC9 B7 1D                 lda   [<MemPtr],y
2077 9ACB 48                    pha   
2078 9ACC F4 0A 00              PushWord #ScrapRecSize 
2079 9ACF A2 0B 09 22           _Multiply 
2080 9AD6 A3 01                 lda   1,s
2081 9AD8 A0 06 00              ldy   #ReadAmount
2082 9ADB 97 1D                 sta   [<MemPtr],y
2083 9ADD 18                    clc   
2084 9ADE 69 02 00              adc   #2
2085 9AE1 83 01                 sta   1,s
2086 9AE3 A3 03                 lda   3,s
2087 9AE5 C8                    iny   
2088 9AE6 C8                    iny   
2089 9AE7 97 1D                 sta   [<MemPtr],y
2090 9AE9 90 03                 bcc   NoCarry
2091 9AEB 1A                    inc   a
2092 9AEC 83 03                 sta   3,s
2093 9AEE              NoCarry   
2094 9AEE
2095 9AEE A0 30 00              ldy   #FirstScrapHandle+2
2096 9AF1 B7 1D                 lda   [<MemPtr],y
2097 9AF3 48                    pha   
2098 9AF4 88                    dey   
2099 9AF5 88                    dey   
2100 9AF6 B7 1D                 lda   [<MemPtr],y
2101 9AF8 48                    pha   
2102 9AF9 A2 02 19 22           _SetHandleSize 
2103 9B00 90 03                 bcc   SizeOK
2104 9B02 4C 92 9B              jmp   ERROR
2105 9B05              SizeOK    
2106 9B05
2107 9B05 20 49 99              jsr   DerefFirstHandle
2108 9B08
2109 9B08 A0 2C 00              ldy   #NumEntries
2110 9B0B B7 1D                 lda   [<MemPtr],y
2111 9B0D 87 01                 sta   [<ScrapTablePtr]
2112 9B0F
2113 9B0F A5 01                 lda   <ScrapTablePtr
2114 9B11 18                    clc   
2115 9B12 69 02 00              adc   #2
2116 9B15 A0 02 00              ldy   #ReadTo
2117 9B18 97 1D                 sta   [<MemPtr],y
2118 9B1A A5 03                 lda   <ScrapTablePtr+2
2119 9B1C 90 01                 bcc   NoCarry2
2120 9B1E 1A                    inc   a
2121 9B1F C8           NoCarry2 iny   
2122 9B20 C8                    iny   
2123 9B21 97 1D                 sta   [<MemPtr],y
2124 9B23
2125 9B23 A5 1D                 lda   <MemPtr
2126 9B25 18                    clc   
2127 9B26 69 00 00              adc   #ReadParams
2128 9B29 AA                    tax   
2129 9B2A A5 1F                 lda   <MemPtr+2
2130 9B2C 69 00 00              adc   #0
2131 9B2F 48                    pha   
2132 9B30 DA                    phx   
2133 9B31
2134 9B31 F4 12 00              pea   ReadCall
2135 9B34 22 B0 00 E1           jsl   StackProDOS
2136 9B38
2137 9B38 B0 58                 bcs   ERROR
2138 9B3A
2139 9B3A              ;----------------------------------------------------
2140 9B3A              ;
2141 9B3A              ; Now read in individual scraps.
2142 9B3A              ;
2143 9B3A A5 01                 lda   <ScrapTablePtr
2144 9B3C 18                    clc   
2145 9B3D 69 02 00              adc   #2
2146 9B40 85 09                 sta   <PtrToThisOne
2147 9B42 A5 03                 lda   <ScrapTablePtr+2
2148 9B44 90 01                 bcc   NoCarry3
2149 9B46 1A                    inc   a
2150 9B47 85 0B        NoCarry3 sta   <PtrToThisOne+2
2151 9B49
2152 9B49 A9 00 00              lda   #0
2153 9B4C
2154 9B4C C7 01        Loop     cmp   [<ScrapTablePtr]
2155 9B4E B0 19                 bcs   AllDone
2156 9B50
2157 9B50 48                    pha   
2158 9B51 20 AE 9B              jsr   ReadInThisOne
2159 9B54 B0 3B                 bcs   ERROR2
2160 9B56
2161 9B56 A5 09                 lda   <PtrToThisOne
2162 9B58 18                    clc   
2163 9B59 69 0A 00              adc   #ScrapRecSize
2164 9B5C 85 09                 sta   <PtrToThisOne
2165 9B5E A5 0B                 lda   <PtrToThisOne+2
2166 9B60 90 01                 bcc   NoCarry4
2167 9B62 1A                    inc   a
2168 9B63 85 0B        NoCarry4 sta   <PtrToThisOne+2
2169 9B65
2170 9B65 68                    pla   
2171 9B66 1A                    inc   a
2172 9B67 80 E3                 bra   Loop
2173 9B69
2174 9B69              AllDone   
2175 9B69
2176 9B69              ;----------------------------------------------------
2177 9B69              ;
2178 9B69              ; Close it all down.
2179 9B69              ;
2180 9B69 A5 1D                 lda   <MemPtr
2181 9B6B 18                    clc   
2182 9B6C 69 00 00              adc   #CloseParams
2183 9B6F AA                    tax   
2184 9B70 A5 1F                 lda   <MemPtr+2
2185 9B72 69 00 00              adc   #0
2186 9B75 48                    pha   
2187 9B76 DA                    phx   
2188 9B77
2189 9B77 F4 14 00              pea   CloseCall
2190 9B7A 22 B0 00 E1           jsl   StackProDOS
2191 9B7E
2192 9B7E              ;----------------------------------------------------
2193 9B7E              ;
2194 9B7E              ; Set flag to indicate that clipboard is in memory
2195 9B7E              ;
2196 9B7E
2197 9B7E A9 01 00              lda   #1
2198 9B81 A0 32 00              ldy   #ScrapState
2199 9B84 97 1D                 sta   [<MemPtr],y
2200 9B86
2201 9B86
2202 9B86              ;----------------------------------------------------
2203 9B86              ;
2204 9B86              ; Unlock the scrap table
2205 9B86              ;
2206 9B86 20 6C 99              jsr   UnlockFirstHandle
2207 9B89
2208 9B89
2209 9B89
2210 9B89              ;----------------------------------------------------
2211 9B89              ;
2212 9B89              ; Delete the file
2213 9B89              ;
2214 9B89 20 2B 9A              jsr   DeleteClipboard
2215 9B8C
2216 9B8C A9 00 00              lda   #0
2217 9B8F 18                    clc   
2218 9B90
2219 9B90 60                    rts   
2220 9B91
2221 9B91 FA           ERROR2   plx   
2222 9B92 48           ERROR    pha                            ; save error code
2223 9B93
2224 9B93 A5 1D                 lda   <MemPtr                  ; close the clipboard file just in case its
2225 9B95 18                    clc                            ; been left open. 
2226 9B96 69 00 00              adc   #CloseParams             ; HY 5/6/88
2227 9B99 AA                    tax   
2228 9B9A A5 1F                 lda   <MemPtr+2
2229 9B9C 69 00 00              adc   #0
2230 9B9F 48                    pha   
2231 9BA0 DA                    phx   
2232 9BA1
2233 9BA1 F4 14 00              pea   CloseCall
2234 9BA4 22 B0 00 E1           jsl   StackProDOS
2235 9BA8
2236 9BA8 20 6C 99              jsr   UnlockFirstHandle
2237 9BAB 68                    pla                            ; get back error code
2238 9BAC 38                    sec                            ; signal error
2239 9BAD 60                    rts   
2240 9BAE
2241 9BAE                       ENDP 
2242 9BAE
2243 9BAE                       eject 
2244 9BAE              ****************************************************************
2245 9BAE              *
2246 9BAE              * ReadInThisOne
2247 9BAE              *
2248 9BAE              * Reads the scrap whose table entry is pointed to by
2249 9BAE              * PtrToThisOne from the open file.
2250 9BAE              *
2251 9BAE              * If the amount to read is greater than 64K it is read in 64K
2252 9BAE              * chunks since prodos cannot read more than that at once.
2253 9BAE              *
2254 9BAE              * Returns any error in a-reg.
2255 9BAE              *
2256 9BAE              ****************************************************************
2257 9BAE                       ENTRY ReadInThisOne
2258 9BAE              ReadInThisOne PROC 
2259 9BAE
2260 9BAE F4 00 00 F4           PushLong #0 
2261 9BB4 A0 04 00              ldy   #o_ScrapSize+2
2262 9BB7 B7 09                 lda   [<PtrToThisOne],y
2263 9BB9 48                    pha   
2264 9BBA A0 2A 00              ldy   #HowMuchToRead+2
2265 9BBD 97 1D                 sta   [<MemPtr],y
2266 9BBF A0 02 00              ldy   #o_ScrapSize
2267 9BC2 B7 09                 lda   [PtrToThisOne],y
2268 9BC4 48                    pha   
2269 9BC5 A0 28 00              ldy   #HowMuchToRead
2270 9BC8 97 1D                 sta   [<MemPtr],y
2271 9BCA
2272 9BCA F4 01 42              PushWord #ScrapUserID 
2273 9BCD F4 08 00              PushWord #ScrapAttributes 
2274 9BD0 F4 00 00 F4           PushLong #0 
2275 9BD6 A2 02 09 22           _NewHandle 
2276 9BDD 90 03                 bcc   NoError
2277 9BDF
2278 9BDF FA                    plx   
2279 9BE0 FA                    plx   
2280 9BE1 60                    rts   
2281 9BE2
2282 9BE2
2283 9BE2 68           NoError  pla   
2284 9BE3 85 0D                 sta   <DestHandle
2285 9BE5 A0 06 00              ldy   #o_Scraphandle
2286 9BE8 97 09                 sta   [<PtrToThisOne],y
2287 9BEA 68                    pla   
2288 9BEB 85 0F                 sta   <DestHandle+2
2289 9BED C8                    iny   
2290 9BEE C8                    iny   
2291 9BEF 97 09                 sta   [<PtrToThisOne],y
2292 9BF1
2293 9BF1 20 84 99              jsr   DerefDest
2294 9BF4 A5 11                 lda   <DestPtr
2295 9BF6 A0 02 00              ldy   #ReadTo
2296 9BF9 97 1D                 sta   [<MemPtr],y
2297 9BFB A5 13                 lda   <DestPtr+2
2298 9BFD C8                    iny   
2299 9BFE C8                    iny   
2300 9BFF 97 1D                 sta   [<MemPtr],y
2301 9C01
2302 9C01 A0 2A 00     H9C01    ldy   #HowMuchToRead+2
2303 9C04 B7 1D                 lda   [<MemPtr],y
2304 9C06 D0 07                 bne   H9C0F
2305 9C08 A0 28 00              ldy   #HowMuchToRead
2306 9C0B B7 1D                 lda   [<MemPtr],y
2307 9C0D 80 03                 bra   H9C12
2308 9C0F A9 FF FF     H9C0F    lda   #$FFFF
2309 9C12 A0 06 00     H9C12    ldy   #ReadAmount
2310 9C15 97 1D                 sta   [<MemPtr],y
2311 9C17
2312 9C17 A5 1D                 lda   <MemPtr
2313 9C19 18                    clc   
2314 9C1A 69 00 00              adc   #ReadParams
2315 9C1D AA                    tax   
2316 9C1E A5 1F                 lda   <MemPtr+2
2317 9C20 69 00 00              adc   #0
2318 9C23 48                    pha   
2319 9C24 DA                    phx   
2320 9C25
2321 9C25 F4 12 00              pea   ReadCall
2322 9C28 22 B0 00 E1           jsl   StackProDOS
2323 9C2C B0 23                 bcs   Error
2324 9C2E A0 28 00              ldy   #HowMuchToRead
2325 9C31 B7 1D                 lda   [<MemPtr],y
2326 9C33 38                    sec   
2327 9C34 A0 06 00              ldy   #ReadAmount
2328 9C37 F7 1D                 sbc   [<MemPtr],y
2329 9C39 A0 28 00              ldy   #HowMuchToRead
2330 9C3C 97 1D                 sta   [<MemPtr],y
2331 9C3E C8                    iny   
2332 9C3F C8                    iny   
2333 9C40 B7 1D                 lda   [<MemPtr],y
2334 9C42 E9 00 00              sbc   #0
2335 9C45 97 1D                 sta   [<MemPtr],y
2336 9C47 88                    dey   
2337 9C48 88                    dey   
2338 9C49 17 1D                 ora   [<MemPtr],y
2339 9C4B D0 B4                 bne   H9C01
2340 9C4D 18                    clc   
2341 9C4E A9 00 00              lda   #0
2342 9C51
2343 9C51 08           Error    php   
2344 9C52 48                    pha   
2345 9C53 20 99 99              jsr   UnlockDest
2346 9C56 68                    pla   
2347 9C57 28                    plp   
2348 9C58
2349 9C58 60                    rts   
2350 9C59
2351 9C59                       ENDP 
2352 9C59
2353 9C59
2354 9C59                       eject 
2355 9C59              ****************************************************************
2356 9C59              *
2357 9C59              * WriteOutScrap
2358 9C59              *
2359 9C59              * Writes the scrap in memory to disk.  Disposes of scrap in
2360 9C59              * memory.
2361 9C59              *
2362 9C59              * The scrap in memory is written as follows:
2363 9C59              *
2364 9C59              *      First, the ScrapTable is written out as it is (this
2365 9C59              *      includes the handles which won't be valid later but
2366 9C59              *      serve as place holders).
2367 9C59              *
2368 9C59              *      Then each scrap is written out.
2369 9C59              *
2370 9C59              ****************************************************************
2371 9C59                       ENTRY WriteOutScrap
2372 9C59              WriteOutScrap PROC 
2373 9C59
2374 9C59              ;----------------------------------------------------
2375 9C59              ;
2376 9C59              ; First delete anything that may be there.
2377 9C59              ;
2378 9C59 20 2B 9A              jsr   DeleteClipboard
2379 9C5C
2380 9C5C              ;----------------------------------------------------
2381 9C5C              ;
2382 9C5C              ; Now create a new clipboard file
2383 9C5C              ;
2384 9C5C A0 3A 00              ldy   #ScrapName
2385 9C5F B7 1D                 lda   [<MemPtr],y
2386 9C61 A0 0E 00              ldy   #CreatePath
2387 9C64 97 1D                 sta   [<MemPtr],y
2388 9C66 A0 3C 00              ldy   #ScrapName+2
2389 9C69 B7 1D                 lda   [<MemPtr],y
2390 9C6B A0 10 00              ldy   #CreatePath+2
2391 9C6E 97 1D                 sta   [<MemPtr],y
2392 9C70
2393 9C70 A9 C3 00              lda   #$C3
2394 9C73 A0 12 00              ldy   #CreateAccess
2395 9C76 97 1D                 sta   [<MemPtr],y
2396 9C78
2397 9C78 A9 00 00              lda   #ClipFileType
2398 9C7B A0 14 00              ldy   #CreateFileType
2399 9C7E 97 1D                 sta   [<MemPtr],y
2400 9C80
2401 9C80 A9 00 00              lda   #0
2402 9C83 A0 16 00              ldy   #CreateAuxType
2403 9C86 97 1D                 sta   [<MemPtr],y
2404 9C88 C8                    iny   
2405 9C89 C8                    iny   
2406 9C8A 97 1D                 sta   [<MemPtr],y
2407 9C8C
2408 9C8C A9 01 00              lda   #1
2409 9C8F A0 1A 00              ldy   #CreateStType
2410 9C92 97 1D                 sta   [<MemPtr],y
2411 9C94
2412 9C94 A9 00 00              lda   #0
2413 9C97 A0 1C 00              ldy   #CreateDate
2414 9C9A 97 1D                 sta   [<MemPtr],y
2415 9C9C
2416 9C9C A0 1E 00              ldy   #CreateTime
2417 9C9F 97 1D                 sta   [<MemPtr],y
2418 9CA1
2419 9CA1 A5 1D                 lda   <MemPtr
2420 9CA3 18                    clc   
2421 9CA4 69 0E 00              adc   #CreateParams
2422 9CA7 AA                    tax   
2423 9CA8 A5 1F                 lda   <MemPtr+2
2424 9CAA 69 00 00              adc   #0
2425 9CAD 48                    pha   
2426 9CAE DA                    phx   
2427 9CAF
2428 9CAF F4 01 00              pea   CreateCall
2429 9CB2 22 B0 00 E1           jsl   StackProDOS
2430 9CB6
2431 9CB6 90 03                 bcc   NoCreError
2432 9CB8 4C 8D 9D              jmp   Error
2433 9CBB              NoCreError  
2434 9CBB
2435 9CBB
2436 9CBB              ;----------------------------------------------------
2437 9CBB              ;
2438 9CBB              ; Open the file and copy the IDs
2439 9CBB              ;
2440 9CBB A0 3A 00              ldy   #ScrapName
2441 9CBE B7 1D                 lda   [<MemPtr],y
2442 9CC0 A0 02 00              ldy   #OpenPath
2443 9CC3 97 1D                 sta   [<MemPtr],y
2444 9CC5 A0 3C 00              ldy   #ScrapName+2
2445 9CC8 B7 1D                 lda   [<MemPtr],y
2446 9CCA A0 04 00              ldy   #OpenPath+2
2447 9CCD 97 1D                 sta   [<MemPtr],y
2448 9CCF
2449 9CCF A5 1D                 lda   <MemPtr
2450 9CD1 18                    clc   
2451 9CD2 69 00 00              adc   #OpenParams
2452 9CD5 AA                    tax   
2453 9CD6 A5 1F                 lda   <MemPtr+2
2454 9CD8 69 00 00              adc   #0
2455 9CDB 48                    pha   
2456 9CDC DA                    phx   
2457 9CDD
2458 9CDD F4 10 00              pea   OpenCall
2459 9CE0 22 B0 00 E1           jsl   StackProDOS
2460 9CE4
2461 9CE4 90 03                 bcc   NoOpenErr
2462 9CE6 4C 8D 9D              jmp   ERROR
2463 9CE9
2464 9CE9              NoOpenErr  
2465 9CE9
2466 9CE9              ;----------------------------------------------------
2467 9CE9              ;
2468 9CE9              ; Write out the scrap table
2469 9CE9
2470 9CE9 20 49 99              jsr   DerefFirstHandle
2471 9CEC A5 01                 lda   <ScrapTablePtr
2472 9CEE A0 02 00              ldy   #WriteFrom
2473 9CF1 97 1D                 sta   [<MemPtr],y
2474 9CF3 C8                    iny   
2475 9CF4 C8                    iny   
2476 9CF5 A5 03                 lda   <ScrapTablePtr+2
2477 9CF7 97 1D                 sta   [<MemPtr],y
2478 9CF9
2479 9CF9 F4 00 00 F4           PushLong #0 
2480 9CFF A0 30 00              ldy   #FirstScrapHandle+2
2481 9D02 B7 1D                 lda   [<MemPtr],y
2482 9D04 48                    pha   
2483 9D05 88                    dey   
2484 9D06 88                    dey   
2485 9D07 B7 1D                 lda   [<MemPtr],y
2486 9D09 48                    pha   
2487 9D0A A2 02 18 22           _GetHandleSize 
2488 9D11 B0 7A                 bcs   ERROR
2489 9D13
2490 9D13 68                    pla   
2491 9D14 A0 06 00              ldy   #WriteAmount
2492 9D17 97 1D                 sta   [<MemPtr],y
2493 9D19 68                    pla   
2494 9D1A C8                    iny   
2495 9D1B C8                    iny   
2496 9D1C 97 1D                 sta   [<MemPtr],y
2497 9D1E
2498 9D1E A5 1D                 lda   <MemPtr
2499 9D20 18                    clc   
2500 9D21 69 00 00              adc   #WriteParams
2501 9D24 AA                    tax   
2502 9D25 A5 1F                 lda   <MemPtr+2
2503 9D27 69 00 00              adc   #0
2504 9D2A 48                    pha   
2505 9D2B DA                    phx   
2506 9D2C
2507 9D2C F4 13 00              pea   WriteCall
2508 9D2F 22 B0 00 E1           jsl   StackProDOS
2509 9D33
2510 9D33 B0 58                 bcs   ERROR
2511 9D35
2512 9D35              ;----------------------------------------------------
2513 9D35              ;
2514 9D35              ; Now write out individual scraps.
2515 9D35              ;
2516 9D35 A5 01                 lda   <ScrapTablePtr
2517 9D37 18                    clc   
2518 9D38 69 02 00              adc   #2
2519 9D3B 85 09                 sta   <PtrToThisOne
2520 9D3D A5 03                 lda   <ScrapTablePtr+2
2521 9D3F 90 01                 bcc   NoCarry
2522 9D41 1A                    inc   a
2523 9D42 85 0B        NoCarry  sta   <PtrToThisOne+2
2524 9D44
2525 9D44 A9 00 00              lda   #0
2526 9D47
2527 9D47 C7 01        Loop     cmp   [<ScrapTablePtr]
2528 9D49 B0 19                 bcs   AllDone
2529 9D4B
2530 9D4B 48                    pha   
2531 9D4C 20 94 9D              jsr   WriteOutThisOne
2532 9D4F B0 3B                 bcs   ERROR2
2533 9D51
2534 9D51 A5 09                 lda   <PtrToThisOne
2535 9D53 18                    clc   
2536 9D54 69 0A 00              adc   #ScrapRecSize
2537 9D57 85 09                 sta   <PtrToThisOne
2538 9D59 A5 0B                 lda   <PtrToThisOne+2
2539 9D5B 90 01                 bcc   NoCarry2
2540 9D5D 1A                    inc   a
2541 9D5E 85 0B        NoCarry2 sta   <PtrToThisOne+2
2542 9D60
2543 9D60 68                    pla   
2544 9D61 1A                    inc   a
2545 9D62 80 E3                 bra   Loop
2546 9D64
2547 9D64              AllDone   
2548 9D64
2549 9D64              ;----------------------------------------------------
2550 9D64              ;
2551 9D64              ; Close it all down.
2552 9D64              ;
2553 9D64 A5 1D                 lda   <MemPtr
2554 9D66 18                    clc   
2555 9D67 69 00 00              adc   #CloseParams
2556 9D6A AA                    tax   
2557 9D6B A5 1F                 lda   <MemPtr+2
2558 9D6D 69 00 00              adc   #0
2559 9D70 48                    pha   
2560 9D71 DA                    phx   
2561 9D72
2562 9D72 F4 14 00              pea   CloseCall
2563 9D75 22 B0 00 E1           jsl   StackProDOS
2564 9D79
2565 9D79              ;----------------------------------------------------
2566 9D79              ;
2567 9D79              ; Set flag to indicate that clipboard is on disk
2568 9D79              ;
2569 9D79 A0 32 00              ldy   #ScrapState
2570 9D7C A9 00 00              lda   #0
2571 9D7F 97 1D                 sta   [<MemPtr],y
2572 9D81
2573 9D81              ;----------------------------------------------------
2574 9D81              ;
2575 9D81              ; Unlock the scrap table
2576 9D81              ;
2577 9D81 20 6C 99              jsr   UnlockFirstHandle
2578 9D84
2579 9D84              ;----------------------------------------------------
2580 9D84              ;
2581 9D84              ; Get rid of the memory copies of everything.
2582 9D84              ;
2583 9D84 20 CA 99              jsr   DisposeAllScraps
2584 9D87
2585 9D87 A9 00 00              lda   #0                       ; signal no error
2586 9D8A 18                    clc   
2587 9D8B
2588 9D8B 60                    rts   
2589 9D8C
2590 9D8C FA           ERROR2   plx                            ; clean the stack
2591 9D8D 48           ERROR    pha                            ; save error code
2592 9D8E 20 6C 99              jsr   UnlockFirstHandle
2593 9D91 68                    pla                            ; get back error code
2594 9D92 38                    sec                            ; signal error
2595 9D93 60                    rts   
2596 9D94
2597 9D94                       ENDP 
2598 9D94
2599 9D94
2600 9D94                       eject 
2601 9D94              ****************************************************************
2602 9D94              *
2603 9D94              * WriteOutThisOne
2604 9D94              *
2605 9D94              * Writes the scrap whose table entry is pointed to by
2606 9D94              * PtrToThisOne to the open file.
2607 9D94              *
2608 9D94              * If the scrap is larger than 64K it writes it out in 64K
2609 9D94              * pieces since ProDOS cannot handle any more.
2610 9D94              *
2611 9D94              * Returns any error in a-reg.
2612 9D94              *
2613 9D94              * Change History
2614 9D94              *
2615 9D94              * 12 Aug 88         Steven Glass
2616 9D94              *
2617 9D94              * The closefile call was pushing the wrong pointer
2618 9D94              * to the file ref num and leaving the file open.
2619 9D94              *
2620 9D94              * Subsequent calls to read the scrap would fail because
2621 9D94              * of file aready open.
2622 9D94              * 
2623 9D94              ****************************************************************
2624 9D94                       ENTRY WriteOutThisOne
2625 9D94              WriteOutThisOne PROC 
2626 9D94
2627 9D94 A0 06 00              ldy   #o_ScrapHandle
2628 9D97 B7 09                 lda   [<PtrToThisOne],y
2629 9D99 85 0D                 sta   <DestHandle
2630 9D9B C8                    iny   
2631 9D9C C8                    iny   
2632 9D9D B7 09                 lda   [<PtrToThisOne],y
2633 9D9F 85 0F                 sta   <DestHandle+2
2634 9DA1
2635 9DA1 20 84 99              jsr   DerefDest
2636 9DA4 A5 11                 lda   <DestPtr
2637 9DA6 A0 02 00              ldy   #WriteFrom
2638 9DA9 97 1D                 sta   [<MemPtr],y
2639 9DAB A5 13                 lda   <DestPtr+2
2640 9DAD C8                    iny   
2641 9DAE C8                    iny   
2642 9DAF 97 1D                 sta   [<MemPtr],y
2643 9DB1
2644 9DB1 A0 02 00              ldy   #o_ScrapSize
2645 9DB4 B7 09                 lda   [<PtrToThisOne],y
2646 9DB6 A0 24 00              ldy   #HowMuchToWrite
2647 9DB9 97 1D                 sta   [<MemPtr],y
2648 9DBB A0 04 00              ldy   #o_ScrapSize+2
2649 9DBE B7 09                 lda   [PtrToThisOne],y
2650 9DC0 A0 26 00              ldy   #HowMuchToWrite+2
2651 9DC3 97 1D                 sta   [<MemPtr],y
2652 9DC5
2653 9DC5 A0 26 00     H9DC5    ldy   #HowMuchToWrite+2
2654 9DC8 B7 1D                 lda   [<MemPtr],y
2655 9DCA D0 0B                 bne   H9DD7
2656 9DCC 88                    dey   
2657 9DCD 88                    dey   
2658 9DCE B7 1D                 lda   [<MemPtr],y
2659 9DD0 A0 06 00              ldy   #WriteAmount
2660 9DD3 97 1D                 sta   [<MemPtr],y
2661 9DD5 80 03                 bra   H9DDA
2662 9DD7 A9 FF FF     H9DD7    lda   #$FFFF
2663 9DDA 97 1D        H9DDA    sta   [<MemPtr],y
2664 9DDC
2665 9DDC A5 1D                 lda   <MemPtr
2666 9DDE 18                    clc   
2667 9DDF 69 00 00              adc   #WriteParams
2668 9DE2 AA                    tax   
2669 9DE3 A5 1F                 lda   <MemPtr+2
2670 9DE5 69 00 00              adc   #0
2671 9DE8 48                    pha   
2672 9DE9 DA                    phx   
2673 9DEA
2674 9DEA F4 13 00              pea   WriteCall
2675 9DED 22 B0 00 E1           jsl   StackProDOS
2676 9DF1 B0 23                 bcs   Error
2677 9DF3 A0 24 00              ldy   #HowMuchToWrite
2678 9DF6 B7 1D                 lda   [<MemPtr],y
2679 9DF8 38                    sec   
2680 9DF9 A0 06 00              ldy   #WriteAmount
2681 9DFC F7 1D                 sbc   [<MemPtr],y
2682 9DFE A0 24 00              ldy   #HowMuchToWrite
2683 9E01 97 1D                 sta   [<MemPtr],y
2684 9E03 C8                    iny   
2685 9E04 C8                    iny   
2686 9E05 B7 1D                 lda   [<MemPtr],y
2687 9E07 E9 00 00              sbc   #0
2688 9E0A 97 1D                 sta   [<MemPtr],y
2689 9E0C 88                    dey   
2690 9E0D 88                    dey   
2691 9E0E 17 1D                 ora   [<MemPtr],y
2692 9E10 D0 B3                 bne   H9DC5
2693 9E12 18                    clc   
2694 9E13 A9 00 00              lda   #0
2695 9E16
2696 9E16 08           Error    php   
2697 9E17 48                    pha   
2698 9E18 20 99 99              jsr   UnlockDest
2699 9E1B 68                    pla   
2700 9E1C 28                    plp   
2701 9E1D
2702 9E1D 60                    rts   
2703 9E1E
2704 9E1E                       EndP 
2705 9E1E
2706 9E1E                       END   
